/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform.filters;

import java.util.HashMap;
import java.util.Map;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

public final class DelegatingByTypeFilter
implements PostDiscoveryFilter {
    private final Map<Class<? extends TestSource>, PostDiscoveryFilter> delegates = new HashMap<Class<? extends TestSource>, PostDiscoveryFilter>();

    public void addDelegate(Class<? extends TestSource> source, PostDiscoveryFilter filter) {
        this.delegates.put(source, filter);
    }

    public FilterResult apply(TestDescriptor descriptor) {
        TestSource source = descriptor.getSource().orElse(null);
        if (source == null) {
            return FilterResult.included((String)"absent source");
        }
        PostDiscoveryFilter filter = this.delegates.get(source.getClass());
        if (filter == null) {
            return FilterResult.included((String)"unknown source");
        }
        return filter.apply((Object)descriptor);
    }
}

