/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.OutputVisitor;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.OutputsCleaner;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.MutableBeforeExecutionContext;
import org.gradle.internal.execution.steps.MutableStep;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;

public class RemovePreviousOutputsStep<C extends InputChangesContext, R extends Result>
extends MutableStep<C, R> {
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final Step<? super C, ? extends R> delegate;

    public RemovePreviousOutputsStep(Deleter deleter, OutputChangeListener outputChangeListener, Step<? super C, ? extends R> delegate) {
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    protected R executeMutable(MutableUnitOfWork work, C context) {
        if (!((InputChangesContext)context).isIncrementalExecution() && work.shouldCleanupOutputsOnNonIncrementalExecution()) {
            boolean hasOverlappingOutputs = ((MutableBeforeExecutionContext)context).getDetectedOverlappingOutputs().isPresent();
            if (hasOverlappingOutputs) {
                this.cleanupOverlappingOutputs((MutableBeforeExecutionContext)context, work);
            } else {
                this.cleanupExclusivelyOwnedOutputs((MutableBeforeExecutionContext)context, work);
            }
        }
        return this.delegate.execute(work, context);
    }

    private void cleanupOverlappingOutputs(MutableBeforeExecutionContext context, UnitOfWork work) {
        context.getPreviousExecutionState().ifPresent(previousOutputs -> {
            final HashSet outputDirectoriesToPreserve = new HashSet();
            work.visitOutputs(context.getWorkspace(), new OutputVisitor(){

                @Override
                public void visitOutputProperty(String propertyName, TreeType type, OutputVisitor.OutputFileValueSupplier value) {
                    File root = value.getValue();
                    switch (type) {
                        case FILE: {
                            File parentFile = root.getParentFile();
                            if (parentFile == null) break;
                            outputDirectoriesToPreserve.add(parentFile);
                            break;
                        }
                        case DIRECTORY: {
                            outputDirectoriesToPreserve.add(root);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
            });
            OutputsCleaner cleaner = new OutputsCleaner(this.deleter, file -> true, dir -> !outputDirectoriesToPreserve.contains(dir));
            for (FileSystemSnapshot snapshot : previousOutputs.getOutputFilesProducedByWork().values()) {
                try {
                    this.outputChangeListener.invalidateCachesFor(SnapshotUtil.rootIndex((FileSystemSnapshot)snapshot).keySet());
                    cleaner.cleanupOutputs(snapshot);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to clean up output files for " + work.getDisplayName(), e);
                }
            }
        });
    }

    private void cleanupExclusivelyOwnedOutputs(MutableBeforeExecutionContext context, UnitOfWork work) {
        work.visitOutputs(context.getWorkspace(), new OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, OutputVisitor.OutputFileValueSupplier value) {
                File root = value.getValue();
                if (root.exists()) {
                    try {
                        switch (type) {
                            case FILE: {
                                RemovePreviousOutputsStep.this.deleter.delete(root);
                                break;
                            }
                            case DIRECTORY: {
                                RemovePreviousOutputsStep.this.deleter.ensureEmptyDirectory(root);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    catch (IOException ex) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)ex);
                    }
                }
            }
        });
    }
}

