/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicLong;

public interface StatStatistics {
    public long getStatCount();

    public long getUnixModeCount();

    public static class Collector {
        private final AtomicLong statCount = new AtomicLong();
        private final AtomicLong unixModeCount = new AtomicLong();

        public void reportFileStated() {
            this.statCount.incrementAndGet();
        }

        public void reportUnixModeQueried() {
            this.unixModeCount.incrementAndGet();
        }

        public StatStatistics collect() {
            final long unixModeCount = this.unixModeCount.getAndSet(0L);
            final long statCount = this.statCount.getAndSet(0L);
            return new StatStatistics(){

                @Override
                public long getStatCount() {
                    return statCount;
                }

                @Override
                public long getUnixModeCount() {
                    return unixModeCount;
                }

                public String toString() {
                    return MessageFormat.format("Executed stat() x {0,number,integer}. getUnixMode() x {1,number,integer}", statCount, unixModeCount);
                }
            };
        }
    }
}

