/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import org.gradle.internal.operations.BuildOperationMetadata;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.jspecify.annotations.Nullable;

public final class BuildOperationDescriptor {
    private final @Nullable OperationIdentifier id;
    private final @Nullable OperationIdentifier parentId;
    private final String displayName;
    private final String name;
    private final @Nullable String progressDisplayName;
    private final @Nullable Object details;
    private final BuildOperationMetadata metadata;
    private final int totalProgress;

    private BuildOperationDescriptor(@Nullable OperationIdentifier id, @Nullable OperationIdentifier parentId, String name, String displayName, @Nullable String progressDisplayName, @Nullable Object details, BuildOperationMetadata metadata, int totalProgress) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.displayName = displayName;
        this.progressDisplayName = progressDisplayName;
        this.details = details;
        this.metadata = metadata;
        this.totalProgress = totalProgress;
    }

    public @Nullable OperationIdentifier getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public @Nullable String getProgressDisplayName() {
        return this.progressDisplayName;
    }

    public @Nullable Object getDetails() {
        return this.details;
    }

    public @Nullable OperationIdentifier getParentId() {
        return this.parentId;
    }

    public BuildOperationMetadata getMetadata() {
        return this.metadata;
    }

    public int getTotalProgress() {
        return this.totalProgress;
    }

    public static Builder displayName(String displayName) {
        return new Builder(displayName);
    }

    public String toString() {
        return "BuildOperationDescriptor{id=" + this.id + ", parentId=" + this.parentId + ", displayName='" + this.displayName + '\'' + ", name='" + this.name + '\'' + ", progressDisplayName='" + this.progressDisplayName + '\'' + ", details=" + this.details + ", metadata=" + this.metadata + ", totalProgress=" + this.totalProgress + '}';
    }

    public static final class Builder {
        private final String displayName;
        private String name;
        private @Nullable String progressDisplayName;
        private @Nullable Object details;
        private @Nullable BuildOperationRef parent;
        private BuildOperationMetadata metadata = BuildOperationMetadata.NONE;
        private int totalProgress;

        private Builder(String displayName) {
            this.displayName = displayName;
            this.name = displayName;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder progressDisplayName(String progressDisplayName) {
            this.progressDisplayName = progressDisplayName;
            return this;
        }

        public Builder details(Object details) {
            this.details = details;
            return this;
        }

        public Builder metadata(BuildOperationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder totalProgress(int totalProgress) {
            this.totalProgress = totalProgress;
            return this;
        }

        public Builder parent(BuildOperationRef parent) {
            this.parent = parent;
            return this;
        }

        public BuildOperationDescriptor build() {
            return this.build(null, null);
        }

        @Nullable BuildOperationRef getParentState() {
            return this.parent;
        }

        public BuildOperationDescriptor build(@Nullable OperationIdentifier id, @Nullable OperationIdentifier defaultParentId) {
            return new BuildOperationDescriptor(id, this.parent == null ? defaultParentId : this.parent.getId(), this.name, this.displayName, this.progressDisplayName, this.details, this.metadata, this.totalProgress);
        }
    }
}

