/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;

@NullMarked
abstract class SecurityManagerRef {
    private static final boolean SECURITY_MANAGER_AVAILABLE;

    SecurityManagerRef() {
    }

    public static SecurityManagerRef getOrFake() {
        if (SECURITY_MANAGER_AVAILABLE) {
            return new RealSecurityManagerRef();
        }
        return new FakeSecurityManagerRef();
    }

    public abstract void reinstall(Logger var1);

    static {
        boolean isAvailable;
        try {
            Class.forName("java.lang.SecurityManager");
            isAvailable = true;
        }
        catch (ClassNotFoundException e) {
            isAvailable = false;
        }
        SECURITY_MANAGER_AVAILABLE = isAvailable;
    }

    @NullMarked
    private static final class RealSecurityManagerRef
    extends SecurityManagerRef {
        private final SecurityManager reference = System.getSecurityManager();

        private RealSecurityManagerRef() {
        }

        @Override
        public void reinstall(Logger logger) {
            if (System.getSecurityManager() != this.reference) {
                try {
                    System.setSecurityManager(this.reference);
                }
                catch (SecurityException e) {
                    logger.warn("Unable to reset SecurityManager. Continuing anyway...", (Throwable)e);
                }
            }
        }
    }

    @NullMarked
    private static final class FakeSecurityManagerRef
    extends SecurityManagerRef {
        private FakeSecurityManagerRef() {
        }

        @Override
        public void reinstall(Logger logger) {
        }
    }
}

