/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveStateFactory;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.jspecify.annotations.Nullable;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentGraphResolveMetadata>
implements LocalComponentGraphResolveState {
    private final boolean adHoc;
    private final CalculatedValue<LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates> graphSelectionCandidates;

    public DefaultLocalComponentGraphResolveState(long instanceId, LocalComponentGraphResolveMetadata metadata, AttributeDesugaring attributeDesugaring, boolean adHoc, LocalVariantGraphResolveStateFactory variantFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        super(instanceId, metadata, attributeDesugaring);
        this.adHoc = adHoc;
        this.graphSelectionCandidates = calculatedValueContainerFactory.create(Describables.of((Object)"variants of", this.getMetadata()), context -> DefaultLocalComponentGraphResolveState.computeGraphSelectionCandidates(variantFactory));
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentGraphResolveMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public boolean isAdHoc() {
        return this.adHoc;
    }

    @Override
    public ComponentArtifactResolveMetadata getArtifactMetadata() {
        return new LocalComponentArtifactResolveMetadata((ComponentGraphResolveMetadata)this.getMetadata());
    }

    @Override
    public LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        this.graphSelectionCandidates.finalizeIfNotAlready();
        return (LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates)this.graphSelectionCandidates.get();
    }

    private static LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates computeGraphSelectionCandidates(LocalVariantGraphResolveStateFactory variantFactory) {
        ImmutableList.Builder variantsWithAttributes = new ImmutableList.Builder();
        ImmutableMap.Builder variantsByConfigurationName = ImmutableMap.builder();
        variantFactory.visitConsumableVariants(variantState -> {
            if (!variantState.getAttributes().isEmpty()) {
                variantsWithAttributes.add(variantState);
            }
            if (variantState.getMetadata().getConfigurationName() != null) {
                variantsByConfigurationName.put((Object)variantState.getMetadata().getConfigurationName(), variantState);
            }
        });
        return new DefaultLocalComponentGraphSelectionCandidates((List<? extends LocalVariantGraphResolveState>)variantsWithAttributes.build(), (Map<String, LocalVariantGraphResolveState>)variantsByConfigurationName.build());
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ComponentGraphResolveMetadata metadata;

        public LocalComponentArtifactResolveMetadata(ComponentGraphResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return ImmutableModuleSources.of();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public ImmutableAttributesSchema getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }
    }

    private static class DefaultLocalComponentGraphSelectionCandidates
    implements LocalComponentGraphResolveState.LocalComponentGraphSelectionCandidates {
        private final List<? extends LocalVariantGraphResolveState> variantsWithAttributes;
        private final Map<String, LocalVariantGraphResolveState> variantsByConfigurationName;

        public DefaultLocalComponentGraphSelectionCandidates(List<? extends LocalVariantGraphResolveState> variantsWithAttributes, Map<String, LocalVariantGraphResolveState> variantsByConfigurationName) {
            this.variantsWithAttributes = variantsWithAttributes;
            this.variantsByConfigurationName = variantsByConfigurationName;
        }

        public List<? extends LocalVariantGraphResolveState> getVariantsForAttributeMatching() {
            return this.variantsWithAttributes;
        }

        @Override
        public @Nullable VariantGraphResolveState getLegacyVariant() {
            return this.getVariantByConfigurationName("default");
        }

        @Override
        public @Nullable LocalVariantGraphResolveState getVariantByConfigurationName(String name) {
            return this.variantsByConfigurationName.get(name);
        }

        @Override
        public List<LocalVariantGraphResolveState> getAllSelectableVariants() {
            HashSet<String> configurationNames = new HashSet<String>(this.variantsByConfigurationName.keySet());
            for (LocalVariantGraphResolveState localVariantGraphResolveState : this.variantsWithAttributes) {
                if (localVariantGraphResolveState.getMetadata().getConfigurationName() == null) continue;
                configurationNames.remove(localVariantGraphResolveState.getMetadata().getConfigurationName());
            }
            ArrayList<LocalVariantGraphResolveState> result = new ArrayList<LocalVariantGraphResolveState>(this.variantsWithAttributes);
            for (String configurationName : configurationNames) {
                result.add(this.variantsByConfigurationName.get(configurationName));
            }
            return result;
        }
    }
}

