/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.language.nativeplatform.internal.DependentSourceSetInternal;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PreprocessingTool;
import org.gradle.nativeplatform.Tool;
import org.gradle.nativeplatform.internal.DefaultPreprocessingTool;
import org.gradle.nativeplatform.internal.DefaultTool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryRequirementResolveResult;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryResolveResult;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;

public abstract class AbstractNativeBinarySpec
extends BaseBinarySpec
implements NativeBinarySpecInternal {
    private final Set<? super Object> libs = new LinkedHashSet<Object>();
    private final Tool linker = new DefaultTool();
    private final Tool staticLibArchiver = new DefaultTool();
    private final Tool assembler = new DefaultTool();
    private final PreprocessingTool cCompiler = new DefaultPreprocessingTool();
    private final PreprocessingTool cppCompiler = new DefaultPreprocessingTool();
    private final PreprocessingTool objcCompiler = new DefaultPreprocessingTool();
    private final PreprocessingTool objcppCompiler = new DefaultPreprocessingTool();
    private final PreprocessingTool rcCompiler = new DefaultPreprocessingTool();
    private final Map<String, Tool> toolsByName = ImmutableMap.builder().put((Object)"assembler", (Object)this.assembler).put((Object)"cCompiler", (Object)this.cCompiler).put((Object)"cppCompiler", (Object)this.cppCompiler).put((Object)"objcCompiler", (Object)this.objcCompiler).put((Object)"objcppCompiler", (Object)this.objcppCompiler).put((Object)"rcCompiler", (Object)this.rcCompiler).build();
    private PlatformToolProvider toolProvider;
    private Flavor flavor;
    private NativeToolChain toolChain;
    private NativePlatform targetPlatform;
    private BuildType buildType;
    private NativeDependencyResolver resolver;
    private Map<File, PreCompiledHeader> prefixFileToPCH = new HashMap<File, PreCompiledHeader>();
    private FileCollectionFactory fileCollectionFactory;

    public String getDisplayName() {
        return this.getNamingScheme().getDescription();
    }

    @Override
    public NativeComponentSpec getComponent() {
        return (NativeComponentSpec)this.getComponentAs(NativeComponentSpec.class);
    }

    @Override
    public Flavor getFlavor() {
        return this.flavor;
    }

    @Override
    public void setFlavor(Flavor flavor) {
        this.flavor = flavor;
    }

    @Override
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    @Override
    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @Override
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @Override
    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    @Override
    public BuildType getBuildType() {
        return this.buildType;
    }

    @Override
    public void setBuildType(BuildType buildType) {
        this.buildType = buildType;
    }

    @Override
    public Tool getLinker() {
        return this.linker;
    }

    @Override
    public Tool getStaticLibArchiver() {
        return this.staticLibArchiver;
    }

    @Override
    public Tool getAssembler() {
        return this.assembler;
    }

    @Override
    public PreprocessingTool getcCompiler() {
        return this.cCompiler;
    }

    @Override
    public PreprocessingTool getCppCompiler() {
        return this.cppCompiler;
    }

    @Override
    public PreprocessingTool getObjcCompiler() {
        return this.objcCompiler;
    }

    @Override
    public PreprocessingTool getObjcppCompiler() {
        return this.objcppCompiler;
    }

    @Override
    public PreprocessingTool getRcCompiler() {
        return this.rcCompiler;
    }

    @Override
    public Tool getToolByName(String name) {
        return this.toolsByName.get(name);
    }

    @Override
    public Collection<NativeDependencySet> getLibs() {
        return this.resolve((Iterable<? extends DependentSourceSet>)this.getInputs().withType(DependentSourceSet.class)).getAllResults();
    }

    @Override
    public Collection<NativeDependencySet> getLibs(DependentSourceSet sourceSet) {
        return this.resolve(Collections.singleton(sourceSet)).getAllResults();
    }

    @Override
    public void lib(Object notation) {
        this.libs.add(notation);
    }

    @Override
    public Collection<NativeLibraryBinary> getDependentBinaries() {
        return this.resolve((Iterable<? extends DependentSourceSet>)this.getInputs().withType(DependentSourceSet.class)).getAllLibraryBinaries();
    }

    @Override
    public Collection<NativeBinaryRequirementResolveResult> getAllResolutions() {
        return this.resolve((Iterable<? extends DependentSourceSet>)this.getInputs().withType(DependentSourceSet.class)).getAllResolutions();
    }

    @Override
    public Map<File, PreCompiledHeader> getPrefixFileToPCH() {
        return this.prefixFileToPCH;
    }

    @Override
    public void addPreCompiledHeaderFor(DependentSourceSet sourceSet) {
        this.prefixFileToPCH.put(((DependentSourceSetInternal)sourceSet).getPrefixHeaderFile(), new PreCompiledHeader(this.getIdentifier().child("pch")));
    }

    private NativeBinaryResolveResult resolve(Iterable<? extends DependentSourceSet> sourceSets) {
        LinkedHashSet<? super Object> allLibs = new LinkedHashSet<Object>(this.libs);
        for (DependentSourceSet dependentSourceSet : sourceSets) {
            allLibs.addAll(dependentSourceSet.getLibs());
        }
        NativeBinaryResolveResult resolution = new NativeBinaryResolveResult(this, allLibs);
        this.resolver.resolve(resolution);
        return resolution;
    }

    @Override
    public PlatformToolProvider getPlatformToolProvider() {
        return this.toolProvider;
    }

    @Override
    public void setPlatformToolProvider(PlatformToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    @Override
    public void setResolver(NativeDependencyResolver resolver) {
        this.resolver = resolver;
    }

    protected FileCollectionFactory getFileCollectionFactory() {
        return this.fileCollectionFactory;
    }

    @Override
    public void setFileCollectionFactory(FileCollectionFactory fileCollectionFactory) {
        this.fileCollectionFactory = fileCollectionFactory;
    }

    protected BinaryBuildAbility getBinaryBuildAbility() {
        NativeToolChainInternal toolChainInternal = (NativeToolChainInternal)this.getToolChain();
        NativePlatformInternal platformInternal = (NativePlatformInternal)this.getTargetPlatform();
        return new ToolSearchBuildAbility((ToolSearchResult)toolChainInternal.select(platformInternal));
    }

    @Override
    public void binaryInputs(FileCollection files) {
        this.getCreateOrLink().source(files);
    }

    protected abstract ObjectFilesToBinary getCreateOrLink();
}

