/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.function.Function;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.composite.internal.RootOfNestedBuildTree;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.internal.build.BuildLayoutValidator;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.buildtree.BuildActionModelRequirements;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildModelParametersFactory;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.NestedBuildTree;
import org.gradle.internal.buildtree.RunTasksRequirements;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.internal.time.Time;
import org.gradle.util.Path;

public class DefaultNestedBuildTree
implements NestedBuildTree {
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final BuildDefinition buildDefinition;
    private final Path identityPath;
    private final BuildState owner;
    private final GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry;
    private final CrossBuildSessionState crossBuildSessionState;
    private final BuildCancellationToken buildCancellationToken;

    public DefaultNestedBuildTree(BuildInvocationScopeId buildInvocationScopeId, BuildDefinition buildDefinition, Path identityPath, BuildState owner, GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry, CrossBuildSessionState crossBuildSessionState, BuildCancellationToken buildCancellationToken) {
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.buildDefinition = buildDefinition;
        this.identityPath = identityPath;
        this.owner = owner;
        this.userHomeDirServiceRegistry = userHomeDirServiceRegistry;
        this.crossBuildSessionState = crossBuildSessionState;
        this.buildCancellationToken = buildCancellationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Function<? super BuildTreeLifecycleController, T> buildAction) {
        StartParameterInternal startParameter = this.buildDefinition.getStartParameter();
        DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
        try (BuildSessionState session = new BuildSessionState(this.userHomeDirServiceRegistry, this.crossBuildSessionState, startParameter, (BuildRequestMetaData)buildRequestMetaData, ClassPath.EMPTY, this.buildCancellationToken, buildRequestMetaData.getClient(), (BuildEventConsumer)new NoOpBuildEventConsumer());){
            T t;
            ServiceRegistry buildSessionServices = session.getServices();
            ((BuildLayoutValidator)buildSessionServices.get(BuildLayoutValidator.class)).validate(startParameter);
            RunTasksRequirements buildActionRequirements = new RunTasksRequirements(startParameter);
            BuildModelParameters buildModelParameters = ((BuildModelParametersFactory)buildSessionServices.get(BuildModelParametersFactory.class)).parametersForNestedBuildTree((BuildActionModelRequirements)buildActionRequirements);
            BuildTreeState buildTree = new BuildTreeState(buildSessionServices, (BuildActionModelRequirements)buildActionRequirements, buildModelParameters, this.buildInvocationScopeId);
            try {
                RootOfNestedBuildTree rootBuild = new RootOfNestedBuildTree(this.buildDefinition, this.identityPath, this.owner, buildTree);
                rootBuild.attach();
                t = rootBuild.run(buildAction);
            }
            catch (Throwable throwable) {
                buildTree.close();
                throw throwable;
            }
            buildTree.close();
            return t;
        }
    }
}

