/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.ClassPathToClassLoaderCache;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.groovyloader.GroovySystemLoader;
import org.gradle.internal.groovyloader.GroovySystemLoaderFactory;
import org.gradle.internal.jvm.Jvm;

public class DefaultIsolatedAntBuilder
implements IsolatedAntBuilder,
Stoppable {
    private static final Logger LOG = Logging.getLogger(DefaultIsolatedAntBuilder.class);
    private final ClassLoader antLoader;
    private final ClassLoader baseAntLoader;
    private final ClassPath libClasspath;
    private final ClassLoader antAdapterLoader;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderFactory classLoaderFactory;
    private final ModuleRegistry moduleRegistry;
    private final ClassPathToClassLoaderCache classLoaderCache;
    private final GroovySystemLoader gradleApiGroovyLoader;
    private final GroovySystemLoader antAdapterGroovyLoader;

    @Inject
    public DefaultIsolatedAntBuilder(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory, ModuleRegistry moduleRegistry) {
        this.classPathRegistry = classPathRegistry;
        this.classLoaderFactory = classLoaderFactory;
        this.moduleRegistry = moduleRegistry;
        this.libClasspath = ClassPath.EMPTY;
        GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
        this.classLoaderCache = new ClassPathToClassLoaderCache(groovySystemLoaderFactory);
        ArrayList antClasspath = Lists.newArrayList((Iterable)classPathRegistry.getClassPath("ANT").getAsFiles());
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            antClasspath.add(toolsJar);
        }
        this.antLoader = classLoaderFactory.createIsolatedClassLoader("isolated-ant-loader", DefaultClassPath.of((Collection)antClasspath));
        FilteringClassLoader.Spec loggingLoaderSpec = new FilteringClassLoader.Spec();
        loggingLoaderSpec.allowPackage("org.slf4j");
        loggingLoaderSpec.allowPackage("org.apache.commons.logging");
        loggingLoaderSpec.allowPackage("org.apache.log4j");
        loggingLoaderSpec.allowClass(Logger.class);
        loggingLoaderSpec.allowClass(LogLevel.class);
        FilteringClassLoader loggingLoader = new FilteringClassLoader(this.getClass().getClassLoader(), loggingLoaderSpec);
        this.baseAntLoader = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{this.antLoader, loggingLoader}));
        ClassPath gradleCoreUrls = moduleRegistry.getModule("gradle-core-api").getImplementationClasspath();
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-core").getImplementationClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-logging-api").getImplementationClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-logging").getImplementationClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-ant").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-datetime").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-groovydoc").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-json").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-templates").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-xml").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-base-services").getImplementationClasspath());
        this.antAdapterLoader = VisitableURLClassLoader.fromClassPath((String)"gradle-core-loader", (ClassLoader)this.baseAntLoader, (ClassPath)gradleCoreUrls);
        this.gradleApiGroovyLoader = groovySystemLoaderFactory.forClassLoader(this.getClass().getClassLoader());
        this.antAdapterGroovyLoader = groovySystemLoaderFactory.forClassLoader(this.antAdapterLoader);
    }

    protected DefaultIsolatedAntBuilder(DefaultIsolatedAntBuilder copy, Iterable<File> libClasspath) {
        this.classPathRegistry = copy.classPathRegistry;
        this.classLoaderFactory = copy.classLoaderFactory;
        this.moduleRegistry = copy.moduleRegistry;
        this.antLoader = copy.antLoader;
        this.baseAntLoader = copy.baseAntLoader;
        this.antAdapterLoader = copy.antAdapterLoader;
        this.libClasspath = DefaultClassPath.of(libClasspath);
        this.gradleApiGroovyLoader = copy.gradleApiGroovyLoader;
        this.antAdapterGroovyLoader = copy.antAdapterGroovyLoader;
        this.classLoaderCache = copy.classLoaderCache;
    }

    public ClassPathToClassLoaderCache getClassLoaderCache() {
        return this.classLoaderCache;
    }

    @Override
    public IsolatedAntBuilder withClasspath(Iterable<File> classpath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forking a new isolated ant builder for classpath : {}", classpath);
        }
        return new DefaultIsolatedAntBuilder(this, classpath);
    }

    @Override
    public void execute(Action<AntBuilderDelegate> antBuilderAction) {
        this.classLoaderCache.withCachedClassLoader(this.libClasspath, this.gradleApiGroovyLoader, this.antAdapterGroovyLoader, (Factory<? extends ClassLoader>)((Factory)() -> new VisitableURLClassLoader("ant-lib-loader", this.baseAntLoader, (Collection)this.libClasspath.getAsURLs())), (Action<? super CachedClassLoader>)((Action)cachedClassLoader -> {
            ClassLoader classLoader = cachedClassLoader.getClassLoader();
            Object antBuilder = this.newInstanceOf("org.gradle.api.internal.project.ant.BasicAntBuilder");
            Object antLogger = this.newInstanceOf("org.gradle.api.internal.project.ant.AntLoggingAdapter");
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                this.configureAntBuilder(antBuilder, antLogger);
                antBuilderAction.execute((Object)new AntBuilderDelegate(antBuilder, classLoader));
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalLoader);
                this.disposeBuilder(antBuilder, antLogger);
            }
        }));
    }

    private Object newInstanceOf(String className) {
        try {
            return this.antAdapterLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Object getProject(Object antBuilder) throws Exception {
        return antBuilder.getClass().getMethod("getProject", new Class[0]).invoke(antBuilder, new Object[0]);
    }

    protected void configureAntBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method addBuildListener = projectClass.getDeclaredMethod("addBuildListener", buildListenerClass);
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            Method getBuildListeners = projectClass.getDeclaredMethod("getBuildListeners", new Class[0]);
            Vector listeners = (Vector)getBuildListeners.invoke(project, new Object[0]);
            removeBuildListener.invoke(project, listeners.get(0));
            addBuildListener.invoke(project, antLogger);
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ex);
        }
    }

    protected void disposeBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            removeBuildListener.invoke(project, antLogger);
            antBuilder.getClass().getDeclaredMethod("close", new Class[0]).invoke(antBuilder, new Object[0]);
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ex);
        }
    }

    public void stop() {
        this.classLoaderCache.stop();
        this.gradleApiGroovyLoader.discardTypesFrom(this.antAdapterLoader);
        this.gradleApiGroovyLoader.discardTypesFrom(this.antLoader);
        this.antAdapterGroovyLoader.shutdown();
        ClassLoaderUtils.tryClose((ClassLoader)this.antAdapterLoader);
    }
}

