/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform;

import java.io.File;
import java.util.Optional;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.initialization.transform.BaseInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.services.InjectedInstrumentationServices;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.internal.classpath.transforms.InstrumentingClassTransform;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.internal.instrumentation.reporting.listener.BytecodeUpgradeReportMethodInterceptionListener;
import org.gradle.internal.instrumentation.reporting.listener.MethodInterceptionListener;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Instrumented jars are too big to cache.")
public abstract class ProjectDependencyInstrumentingArtifactTransform
extends BaseInstrumentingArtifactTransform<Parameters> {
    @Override
    @Classpath
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInput();

    public void transform(TransformOutputs outputs) {
        File input = ((FileSystemLocation)this.getInput().get()).getAsFile();
        this.doTransform(input, outputs);
        if (((Boolean)((Parameters)this.getParameters()).getAgentSupported().get()).booleanValue()) {
            this.doOutputOriginalArtifact(input, outputs);
        }
    }

    @Override
    protected BaseInstrumentingArtifactTransform.InstrumentingClassTransformProvider instrumentingClassTransformProvider(TransformOutputs outputs) {
        final Optional interceptionListener = (Boolean)((Parameters)this.getParameters()).getIsUpgradeReport().getOrElse((Object)false) != false ? Optional.of(new BytecodeUpgradeReportMethodInterceptionListener(outputs.file((Object)"gradle-intercepted-methods.report"))) : Optional.empty();
        return new BaseInstrumentingArtifactTransform.InstrumentingClassTransformProvider(){

            @Override
            public InstrumentingClassTransform getClassTransform() {
                return interceptionListener.map(listener -> new InstrumentingClassTransform(BytecodeInterceptorFilter.INSTRUMENTATION_AND_BYTECODE_REPORT, ProjectDependencyInstrumentingArtifactTransform.this.getGradleCoreTypeRegistry(), (MethodInterceptionListener)listener)).orElseGet(() -> new InstrumentingClassTransform(BytecodeInterceptorFilter.INSTRUMENTATION_ONLY, InstrumentationTypeRegistry.EMPTY));
            }

            @Override
            public void close() {
                interceptionListener.ifPresent(BytecodeUpgradeReportMethodInterceptionListener::close);
            }
        };
    }

    private InstrumentationTypeRegistry getGradleCoreTypeRegistry() {
        return ((InjectedInstrumentationServices)this.internalServices.get()).getGradleCoreInstrumentationTypeRegistry();
    }

    public static interface Parameters
    extends BaseInstrumentingArtifactTransform.Parameters {
        @Input
        public Property<Boolean> getIsUpgradeReport();
    }
}

