/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionInputState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.OverlappingOutputDetector;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.MutableBeforeExecutionContext;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.jspecify.annotations.Nullable;

public class CaptureMutableStateBeforeExecutionStep<C extends PreviousExecutionContext, R extends CachingResult>
extends BuildOperationStep<C, R> {
    private final OutputSnapshotter outputSnapshotter;
    private final OverlappingOutputDetector overlappingOutputDetector;
    private final Step<? super MutableBeforeExecutionContext, ? extends R> delegate;

    public CaptureMutableStateBeforeExecutionStep(BuildOperationRunner buildOperationRunner, OutputSnapshotter outputSnapshotter, OverlappingOutputDetector overlappingOutputDetector, Step<? super MutableBeforeExecutionContext, ? extends R> delegate) {
        super(buildOperationRunner);
        this.outputSnapshotter = outputSnapshotter;
        this.overlappingOutputDetector = overlappingOutputDetector;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.executeMutable((MutableUnitOfWork)work, context);
    }

    private R executeMutable(final MutableUnitOfWork work, C context) {
        OverlappingOutputs overlappingOutputs;
        BeforeExecutionState beforeExecutionState;
        boolean shouldCaptureBeforeExecutionState = work.getHistory().isPresent();
        if (shouldCaptureBeforeExecutionState) {
            beforeExecutionState = this.captureExecutionState(work, (PreviousExecutionContext)context);
            overlappingOutputs = this.detectOverlappingOutputs(work, (PreviousExecutionContext)context, beforeExecutionState.getOutputFileLocationSnapshots());
        } else {
            beforeExecutionState = null;
            overlappingOutputs = null;
            work.visitMutableInputs(new InputVisitor(){
                final /* synthetic */ PreviousExecutionContext val$context;
                {
                    this.val$context = previousExecutionContext;
                }

                @Override
                public void visitInputFileProperty(String propertyName, InputBehavior behavior, InputVisitor.InputFileValueSupplier value) {
                    ((FileCollectionInternal)value.getFiles()).visitStructure(work.getInputDependencyChecker(this.val$context.getValidationContext()));
                }
            });
        }
        return (R)((CachingResult)this.delegate.execute(work, new MutableBeforeExecutionContext((PreviousExecutionContext)context, beforeExecutionState, overlappingOutputs)));
    }

    private BeforeExecutionState captureExecutionState(UnitOfWork work, PreviousExecutionContext context) {
        return this.operation(operationContext -> {
            ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
            BeforeExecutionState executionState = CaptureMutableStateBeforeExecutionStep.captureExecutionStateWithOutputs(work, context, unfilteredOutputSnapshots);
            operationContext.setResult((Object)Operation.Result.INSTANCE);
            return executionState;
        }, BuildOperationDescriptor.displayName((String)("Snapshot inputs and outputs before executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE));
    }

    private @Nullable OverlappingOutputs detectOverlappingOutputs(MutableUnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots) {
        if (work.getOverlappingOutputHandling() == MutableUnitOfWork.OverlappingOutputHandling.IGNORE_OVERLAPS) {
            return null;
        }
        ImmutableSortedMap previousOutputSnapshots = context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        return this.overlappingOutputDetector.detect((ImmutableSortedMap<String, FileSystemSnapshot>)previousOutputSnapshots, unfilteredOutputSnapshots);
    }

    private static BeforeExecutionState captureExecutionStateWithOutputs(UnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots) {
        Optional<PreviousExecutionState> previousExecutionState = context.getPreviousExecutionState();
        ImmutableSortedMap previousInputPropertySnapshots = previousExecutionState.map(ExecutionInputState::getInputProperties).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap previousInputFileFingerprints = previousExecutionState.map(ExecutionInputState::getInputFileProperties).orElse(ImmutableSortedMap.of());
        InputFingerprinter.Result newInputs = work.getInputFingerprinter().fingerprintInputProperties((ImmutableSortedMap<String, ValueSnapshot>)previousInputPropertySnapshots, (ImmutableSortedMap<String, ? extends FileCollectionFingerprint>)previousInputFileFingerprints, context.getInputProperties(), context.getInputFileProperties(), work::visitMutableInputs, work.getInputDependencyChecker(context.getValidationContext()));
        return new DefaultBeforeExecutionState(context.getImplementation(), context.getAdditionalImplementations(), newInputs.getAllValueSnapshots(), newInputs.getAllFileFingerprints(), unfilteredOutputSnapshots);
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

