/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.io.File;
import java.util.Objects;
import org.gradle.util.Path;

public abstract class BuildTreeModelTarget {
    private static final Default DEFAULT = new Default();

    public static Default ofDefault() {
        return DEFAULT;
    }

    public static Build ofBuild(File buildRootDir) {
        return new Build(buildRootDir);
    }

    public static Project ofProject(File buildRootDir, String projectPath) {
        return new Project(buildRootDir, Path.path((String)projectPath));
    }

    public String describeTargetScope() {
        throw new IllegalStateException("Unknown target: " + this);
    }

    public static class Default
    extends BuildTreeModelTarget {
        private Default() {
        }

        public String toString() {
            return "Default";
        }

        @Override
        public String describeTargetScope() {
            return "default scope";
        }
    }

    public static class Build
    extends BuildTreeModelTarget {
        private final File buildRootDir;

        private Build(File buildRootDir) {
            this.buildRootDir = buildRootDir;
        }

        public File getBuildRootDir() {
            return this.buildRootDir;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Build)) {
                return false;
            }
            Build build = (Build)o;
            return this.buildRootDir.equals(build.buildRootDir);
        }

        public int hashCode() {
            return this.buildRootDir.hashCode();
        }

        public String toString() {
            return "Build{buildRootDir=" + this.buildRootDir + '}';
        }

        @Override
        public String describeTargetScope() {
            return "build scope";
        }
    }

    public static class Project
    extends BuildTreeModelTarget {
        private final File buildRootDir;
        private final Path projectPath;

        private Project(File buildRootDir, Path projectPath) {
            this.buildRootDir = buildRootDir;
            this.projectPath = projectPath;
        }

        public File getBuildRootDir() {
            return this.buildRootDir;
        }

        public Path getProjectPath() {
            return this.projectPath;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Project)) {
                return false;
            }
            Project that = (Project)o;
            return this.buildRootDir.equals(that.buildRootDir) && Objects.equals(this.projectPath, that.projectPath);
        }

        public int hashCode() {
            int result = this.buildRootDir.hashCode();
            result = 31 * result + Objects.hashCode(this.projectPath);
            return result;
        }

        public String toString() {
            return "Project{buildRootDir=" + this.buildRootDir + ", projectPath=" + this.projectPath + '}';
        }

        @Override
        public String describeTargetScope() {
            return "project scope";
        }
    }
}

