/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import org.jspecify.annotations.Nullable;

public abstract class PersistentList<T>
implements Iterable<T> {
    private static final PersistentList<Object> NIL = new PersistentList<Object>(){

        @Override
        public void forEach(Consumer<? super Object> consumer) {
        }

        @Override
        public PersistentList<Object> plus(Object element) {
            return new Cons<Object>(element, this);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "Nil";
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }
    };

    public static <T> PersistentList<T> of() {
        return NIL;
    }

    public static <T> PersistentList<T> of(T first) {
        return PersistentList.of().plus(first);
    }

    @SafeVarargs
    public static <T> PersistentList<T> of(T first, T second, T ... rest) {
        PersistentList<T> result = PersistentList.of();
        for (int i = rest.length - 1; i >= 0; --i) {
            result = result.plus(rest[i]);
        }
        return result.plus(second).plus(first);
    }

    @Override
    public abstract void forEach(Consumer<? super T> var1);

    @CheckReturnValue
    public abstract PersistentList<T> plus(T var1);

    public abstract boolean isEmpty();

    private PersistentList() {
    }

    private static class Cons<T>
    extends PersistentList<T> {
        private final T head;
        private final PersistentList<T> tail;

        public Cons(T head, PersistentList<T> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            PersistentList cur = this;
            while (!((PersistentList)cur).isEmpty()) {
                Cons cons = cur;
                consumer.accept(cons.head);
                cur = cons.tail;
            }
        }

        @Override
        public PersistentList<T> plus(T element) {
            return new Cons<T>(element, this);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cons cons = (Cons)o;
            return this.head.equals(cons.head) && this.tail.equals(cons.tail);
        }

        public int hashCode() {
            return Objects.hash(this.head, this.tail);
        }

        public String toString() {
            return this.tail == NIL ? this.head.toString() : this.head + " : " + this.tail;
        }

        @Override
        public Iterator<T> iterator() {
            return new PersistentListIterator(this);
        }

        private static class PersistentListIterator<T>
        extends AbstractIterator<T> {
            PersistentList<T> next;

            public PersistentListIterator(Cons<T> next) {
                this.next = next;
            }

            protected @Nullable T computeNext() {
                if (this.next.isEmpty()) {
                    return (T)this.endOfData();
                }
                Cons current = (Cons)this.next;
                this.next = current.tail;
                return (T)current.head;
            }
        }
    }
}

