/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.internal.ConfigurationCacheDegradationController;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.cc.impl.DefaultConfigurationCacheDegradationControllerKt;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0001'B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0002J\u001e\u0010 \u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00110!H\u0002J\u001a\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00110!H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010&\u001a\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController;", "Lorg/gradle/api/internal/ConfigurationCacheDegradationController;", "Lorg/gradle/api/internal/project/HoldsProjectState;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "vcsMappingsStore", "Lorg/gradle/vcs/internal/VcsMappingsStore;", "buildModelParameters", "Lorg/gradle/internal/buildtree/BuildModelParameters;", "<init>", "(Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/vcs/internal/VcsMappingsStore;Lorg/gradle/internal/buildtree/BuildModelParameters;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "tasksDegradationRequests", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/gradle/api/Task;", "", "Lorg/gradle/api/provider/Provider;", "", "degradationDecision", "Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController$DegradationDecision;", "getDegradationDecision", "()Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController$DegradationDecision;", "degradationDecision$delegate", "Lkotlin/Lazy;", "requireConfigurationCacheDegradation", "", "task", "reason", "discardAll", "collectDegradationReasons", "collectTaskDegradationReasons", "", "Lorg/gradle/api/internal/project/taskfactory/TaskIdentity;", "collectFeatureDegradationReasons", "workGraphContains", "", "isSourceDependenciesUsed", "DegradationDecision", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nDefaultConfigurationCacheDegradationController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultConfigurationCacheDegradationController.kt\norg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1617#2,9:127\n1869#2:136\n1870#2:138\n1626#2:139\n1#3:137\n*S KotlinDebug\n*F\n+ 1 DefaultConfigurationCacheDegradationController.kt\norg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController\n*L\n73#1:127,9\n73#1:136\n73#1:138\n73#1:139\n73#1:137\n*E\n"})
public final class DefaultConfigurationCacheDegradationController
implements ConfigurationCacheDegradationController,
HoldsProjectState {
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final VcsMappingsStore vcsMappingsStore;
    @NotNull
    private final BuildModelParameters buildModelParameters;
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<Task, List<Provider<String>>> tasksDegradationRequests;
    @NotNull
    private final Lazy degradationDecision$delegate;

    public DefaultConfigurationCacheDegradationController(@NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull VcsMappingsStore vcsMappingsStore, @NotNull BuildModelParameters buildModelParameters) {
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)vcsMappingsStore, (String)"vcsMappingsStore");
        Intrinsics.checkNotNullParameter((Object)buildModelParameters, (String)"buildModelParameters");
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.vcsMappingsStore = vcsMappingsStore;
        this.buildModelParameters = buildModelParameters;
        this.logger = Logging.getLogger(DefaultConfigurationCacheDegradationController.class);
        this.tasksDegradationRequests = new ConcurrentHashMap();
        this.degradationDecision$delegate = LazyKt.lazy(() -> DefaultConfigurationCacheDegradationController.degradationDecision_delegate$lambda$0(this));
    }

    @NotNull
    public final DegradationDecision getDegradationDecision() {
        Lazy lazy = this.degradationDecision$delegate;
        return (DegradationDecision)lazy.getValue();
    }

    public void requireConfigurationCacheDegradation(@NotNull Task task, @NotNull Provider<String> reason) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(reason, (String)"reason");
        if (!this.configurationTimeBarrier.isAtConfigurationTime()) {
            this.logger.debug("Configuration cache degradation request of task {} is ignored at execution time", (Object)task.getPath());
            return;
        }
        this.tasksDegradationRequests.compute(task, new BiFunction(reason){
            final /* synthetic */ Provider<String> $reason;
            {
                this.$reason = $reason;
            }

            public final List<Provider<String>> apply(Task task, List<? extends Provider<String>> reasons) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"<unused var>");
                List list = reasons;
                if (list == null || (list = CollectionsKt.plus((Collection)list, this.$reason)) == null) {
                    list = CollectionsKt.listOf(this.$reason);
                }
                return list;
            }
        });
    }

    public void discardAll() {
        this.tasksDegradationRequests.clear();
    }

    private final DegradationDecision collectDegradationReasons() {
        return this.buildModelParameters.isRequiresToolingModels() ? DegradationDecision.Companion.getShouldNotDegrade() : new DegradationDecision(this.collectTaskDegradationReasons(), this.collectFeatureDegradationReasons());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TaskIdentity<?>, List<String>> collectTaskDegradationReasons() {
        Map map;
        if (!((Map)this.tasksDegradationRequests).isEmpty()) {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.tasksDegradationRequests.size());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builderWithExpectedSize(...)");
            ImmutableMap.Builder builder2 = builder;
            for (Map.Entry entry : ((Map)this.tasksDegradationRequests).entrySet()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Task task = (Task)entry.getKey();
                List reasons = (List)entry.getValue();
                if (!this.workGraphContains(task)) continue;
                Iterable iterable = reasons;
                boolean $i$f$mapNotNull = false;
                void var10_9 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Provider it = (Provider)element$iv$iv;
                    boolean bl2 = false;
                    if ((String)it.getOrNull() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List reasonsInEffect = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                if (!(!((Collection)reasonsInEffect).isEmpty())) continue;
                builder2.put((Object)DefaultConfigurationCacheDegradationControllerKt.access$getIdentity(task), (Object)reasonsInEffect);
            }
            ImmutableMap immutableMap = builder2.build();
            Intrinsics.checkNotNull((Object)immutableMap);
            map = (Map)immutableMap;
        } else {
            ImmutableMap immutableMap = ImmutableMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
            map = (Map)immutableMap;
        }
        return map;
    }

    private final Map<String, List<String>> collectFeatureDegradationReasons() {
        Map map;
        if (this.isSourceDependenciesUsed()) {
            ImmutableMap immutableMap = ImmutableMap.of((Object)"source dependencies", (Object)CollectionsKt.listOf((Object)"Source dependencies are not compatible yet"));
            Intrinsics.checkNotNull((Object)immutableMap);
            map = (Map)immutableMap;
        } else {
            ImmutableMap immutableMap = ImmutableMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
            map = (Map)immutableMap;
        }
        return map;
    }

    private final boolean workGraphContains(Task task) {
        return task.getProject().getGradle().getTaskGraph().hasTask(task);
    }

    private final boolean isSourceDependenciesUsed() {
        return this.vcsMappingsStore.asResolver().hasRules();
    }

    private static final DegradationDecision degradationDecision_delegate$lambda$0(DefaultConfigurationCacheDegradationController this$0) {
        return this$0.collectDegradationReasons();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0080\b\u0018\u0000  2\u00020\u0001:\u0001 B?\u0012\u001c\u0010\u0002\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0004J*\u0010\u0014\u001a\u00020\u00152\"\u0010\u0016\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00150\u0017J&\u0010\u0018\u001a\u00020\u00152\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00150\u0017J\u001f\u0010\u0019\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c2\u0003J\u001b\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c2\u0003JE\u0010\u001b\u001a\u00020\u00002\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001R$\u0010\u0002\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController$DegradationDecision;", "", "taskDegradationReasons", "", "Lorg/gradle/api/internal/project/taskfactory/TaskIdentity;", "", "", "featureDegradationReasons", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "shouldDegrade", "", "getShouldDegrade", "()Z", "degradedTaskCount", "", "getDegradedTaskCount", "()I", "degradationReasonForTask", "taskIdentity", "onDegradedTask", "", "consumer", "Lkotlin/Function2;", "onDegradedFeature", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "Companion", "configuration-cache"})
    public static final class DegradationDecision {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<TaskIdentity<?>, List<String>> taskDegradationReasons;
        @NotNull
        private final Map<String, List<String>> featureDegradationReasons;
        @NotNull
        private static final DegradationDecision shouldNotDegrade;

        public DegradationDecision(@NotNull Map<TaskIdentity<?>, ? extends List<String>> taskDegradationReasons, @NotNull Map<String, ? extends List<String>> featureDegradationReasons) {
            Intrinsics.checkNotNullParameter(taskDegradationReasons, (String)"taskDegradationReasons");
            Intrinsics.checkNotNullParameter(featureDegradationReasons, (String)"featureDegradationReasons");
            this.taskDegradationReasons = taskDegradationReasons;
            this.featureDegradationReasons = featureDegradationReasons;
        }

        public final boolean getShouldDegrade() {
            return !this.taskDegradationReasons.isEmpty() || !this.featureDegradationReasons.isEmpty();
        }

        public final int getDegradedTaskCount() {
            return this.taskDegradationReasons.size();
        }

        @Nullable
        public final List<String> degradationReasonForTask(@NotNull TaskIdentity<?> taskIdentity) {
            Intrinsics.checkNotNullParameter(taskIdentity, (String)"taskIdentity");
            return this.taskDegradationReasons.get(taskIdentity);
        }

        public final void onDegradedTask(@NotNull Function2<? super TaskIdentity<?>, ? super List<String>, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.taskDegradationReasons.forEach(new BiConsumer(consumer){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void accept(Object p0, Object p1) {
                    this.function.invoke(p0, p1);
                }
            });
        }

        public final void onDegradedFeature(@NotNull Function2<? super String, ? super List<String>, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.featureDegradationReasons.forEach(new /* invalid duplicate definition of identical inner class */);
        }

        private final Map<TaskIdentity<?>, List<String>> component1() {
            return this.taskDegradationReasons;
        }

        private final Map<String, List<String>> component2() {
            return this.featureDegradationReasons;
        }

        @NotNull
        public final DegradationDecision copy(@NotNull Map<TaskIdentity<?>, ? extends List<String>> taskDegradationReasons, @NotNull Map<String, ? extends List<String>> featureDegradationReasons) {
            Intrinsics.checkNotNullParameter(taskDegradationReasons, (String)"taskDegradationReasons");
            Intrinsics.checkNotNullParameter(featureDegradationReasons, (String)"featureDegradationReasons");
            return new DegradationDecision(taskDegradationReasons, featureDegradationReasons);
        }

        public static /* synthetic */ DegradationDecision copy$default(DegradationDecision degradationDecision, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map = degradationDecision.taskDegradationReasons;
            }
            if ((n & 2) != 0) {
                map2 = degradationDecision.featureDegradationReasons;
            }
            return degradationDecision.copy(map, map2);
        }

        @NotNull
        public String toString() {
            return "DegradationDecision(taskDegradationReasons=" + this.taskDegradationReasons + ", featureDegradationReasons=" + this.featureDegradationReasons + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.taskDegradationReasons).hashCode();
            result2 = result2 * 31 + ((Object)this.featureDegradationReasons).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DegradationDecision)) {
                return false;
            }
            DegradationDecision degradationDecision = (DegradationDecision)other;
            if (!Intrinsics.areEqual(this.taskDegradationReasons, degradationDecision.taskDegradationReasons)) {
                return false;
            }
            return Intrinsics.areEqual(this.featureDegradationReasons, degradationDecision.featureDegradationReasons);
        }

        static {
            ImmutableMap immutableMap = ImmutableMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
            Map map = (Map)immutableMap;
            ImmutableMap immutableMap2 = ImmutableMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap2, (String)"of(...)");
            shouldNotDegrade = new DegradationDecision(map, (Map)immutableMap2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController$DegradationDecision$Companion;", "", "<init>", "()V", "shouldNotDegrade", "Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController$DegradationDecision;", "getShouldNotDegrade", "()Lorg/gradle/internal/cc/impl/DefaultConfigurationCacheDegradationController$DegradationDecision;", "configuration-cache"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DegradationDecision getShouldNotDegrade() {
                return shouldNotDegrade;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

