/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.jspecify.annotations.Nullable;

public abstract class AbstractBuildOption<T, V extends CommandLineOptionConfiguration>
implements BuildOption<T> {
    protected final @Nullable String property;
    protected final List<V> commandLineOptionConfigurations;
    protected final @Nullable String deprecatedProperty;

    public AbstractBuildOption(String property) {
        this(property, (String)null, Collections.emptyList());
    }

    public AbstractBuildOption(@Nullable String property, V ... commandLineOptionConfiguration) {
        this(property, (String)null, Arrays.asList(commandLineOptionConfiguration));
    }

    public AbstractBuildOption(@Nullable String property, String deprecatedProperty) {
        this(property, deprecatedProperty, Collections.emptyList());
    }

    public AbstractBuildOption(@Nullable String property, @Nullable String deprecatedProperty, V ... commandLineOptionConfiguration) {
        this(property, deprecatedProperty, Arrays.asList(commandLineOptionConfiguration));
    }

    private AbstractBuildOption(@Nullable String property, @Nullable String deprecatedProperty, List<V> commandLineOptionConfigurations) {
        this.property = property;
        this.deprecatedProperty = deprecatedProperty;
        this.commandLineOptionConfigurations = commandLineOptionConfigurations;
    }

    @Override
    public @Nullable String getProperty() {
        return this.property;
    }

    @Override
    public @Nullable String getDeprecatedProperty() {
        return this.deprecatedProperty;
    }

    protected CommandLineOption configureCommandLineOption(CommandLineParser parser, String[] options, String description, boolean deprecated, boolean incubating) {
        CommandLineOption option = parser.option(options).hasDescription(description);
        if (deprecated) {
            option.deprecated();
        }
        if (incubating) {
            option.incubating();
        }
        return option;
    }

    protected OptionValue<String> getFromProperties(Map<String, String> properties) {
        String value = properties.get(this.property);
        if (value != null) {
            return new OptionValue<String>(value, Origin.forGradleProperty(this.property));
        }
        if (this.deprecatedProperty != null && (value = properties.get(this.deprecatedProperty)) != null) {
            return new OptionValue<String>(value, Origin.forGradleProperty(this.deprecatedProperty));
        }
        return new OptionValue<Object>(null, null);
    }

    @Override
    public void applyFromEnvVar(Map<String, String> envVars, T settings) {
    }

    protected static class OptionValue<T> {
        private final @Nullable T value;
        private final @Nullable Origin origin;

        public OptionValue(@Nullable T value, @Nullable Origin origin) {
            this.value = value;
            this.origin = origin;
        }

        public @Nullable T getValue() {
            return this.value;
        }

        public @Nullable Origin getOrigin() {
            return this.origin;
        }
    }
}

