/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.tasks.testing.TestWorkerFailureException;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.util.internal.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCountLogger
implements TestListener {
    private final ProgressLoggerFactory factory;
    private ProgressLogger progressLogger;
    private final Logger logger;
    private long totalTests;
    private long totalDiscoveredItems;
    private long failedTests;
    private long skippedTests;
    private boolean hadFailures;
    private List<TestFailure> workerFailures;

    public TestCountLogger(ProgressLoggerFactory factory) {
        this(factory, LoggerFactory.getLogger(TestCountLogger.class));
    }

    TestCountLogger(ProgressLoggerFactory factory, Logger logger) {
        this.factory = factory;
        this.logger = logger;
        this.workerFailures = new ArrayList<TestFailure>();
    }

    @Override
    public void beforeTest(TestDescriptor testDescriptor) {
    }

    @Override
    public void afterTest(TestDescriptor testDescriptor, TestResult result) {
        this.totalTests += result.getTestCount();
        this.totalDiscoveredItems += result.getTestCount();
        this.failedTests += result.getFailedTestCount();
        this.skippedTests += result.getSkippedTestCount();
        this.progressLogger.progress(this.summary());
    }

    private String summary() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, this.totalTests, "test");
        builder.append(" completed");
        if (this.failedTests > 0L) {
            builder.append(", ");
            builder.append(this.failedTests);
            builder.append(" failed");
        }
        if (this.skippedTests > 0L) {
            builder.append(", ");
            builder.append(this.skippedTests);
            builder.append(" skipped");
        }
        return builder.toString();
    }

    private void append(StringBuilder dest, long count, String noun) {
        dest.append(count);
        dest.append(" ");
        dest.append(noun);
        if (count != 1L) {
            dest.append("s");
        }
    }

    @Override
    public void beforeSuite(TestDescriptor suite) {
        if (suite.getParent() == null) {
            this.progressLogger = this.factory.newOperation(TestCountLogger.class);
            this.progressLogger.setDescription("Run tests");
            this.progressLogger.started();
            this.progressLogger.progress(this.summary());
        }
    }

    @Override
    public void afterSuite(TestDescriptor suite, TestResult result) {
        if (suite.getParent() == null) {
            if (this.failedTests > 0L) {
                this.logger.error(TextUtil.getPlatformLineSeparator() + this.summary());
            }
            this.progressLogger.completed();
            if (result.getResultType() == TestResult.ResultType.FAILURE) {
                this.hadFailures = true;
                this.workerFailures.addAll(result.getFailures());
            }
        } else {
            if (suite.getParent().getParent() == null && suite.getDisplayName().startsWith("Gradle Test Executor") && result.getResultType() == TestResult.ResultType.FAILURE) {
                this.workerFailures.addAll(result.getFailures());
            }
            if (suite.getClassName() != null) {
                ++this.totalDiscoveredItems;
            }
        }
    }

    public boolean hadFailures() {
        return this.hadFailures;
    }

    public long getTotalTests() {
        return this.totalTests;
    }

    public long getTotalDiscoveredItems() {
        return this.totalDiscoveredItems;
    }

    public boolean hasWorkerFailures() {
        return !this.workerFailures.isEmpty();
    }

    public String handleWorkerFailures() {
        throw new TestWorkerFailureException("Test process encountered an unexpected problem.", this.workerFailures.stream().map(TestFailure::getRawFailure).collect(Collectors.toList()), Collections.singletonList("Check common problems " + new DocumentationRegistry().getDocumentationFor("java_testing", "sec:java_testing_troubleshooting") + "."));
    }
}

