/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import java.util.function.Supplier;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.BuildLayoutValidator;
import org.gradle.internal.buildtree.BuildActionModelRequirements;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildModelParametersFactory;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.RunTasksRequirements;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.launcher.exec.QueryModelRequirements;
import org.gradle.launcher.exec.RootBuildLifecycleBuildActionExecutor;
import org.gradle.launcher.exec.RunActionRequirements;
import org.gradle.launcher.exec.RunPhasedActionRequirements;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class BuildTreeLifecycleBuildActionExecutor
implements BuildSessionActionExecutor {
    private final BuildModelParametersFactory buildModelParametersFactory;
    private final BuildLayoutValidator buildLayoutValidator;
    private final ValueSnapshotter valueSnapshotter;

    public BuildTreeLifecycleBuildActionExecutor(BuildModelParametersFactory modelParametersFactory, BuildLayoutValidator buildLayoutValidator, ValueSnapshotter valueSnapshotter) {
        this.buildModelParametersFactory = modelParametersFactory;
        this.buildLayoutValidator = buildLayoutValidator;
        this.valueSnapshotter = valueSnapshotter;
    }

    public BuildActionRunner.Result execute(BuildAction action, BuildSessionContext buildSession) {
        BuildActionRunner.Result result = null;
        try {
            this.buildLayoutValidator.validate(action.getStartParameter());
            BuildActionModelRequirements actionRequirements = this.buildActionModelRequirementsFor(action);
            BuildModelParameters buildModelParameters = this.buildModelParametersFactory.parametersForRootBuildTree(actionRequirements);
            result = BuildTreeLifecycleBuildActionExecutor.runRootBuildAction(action, buildSession.getServices(), actionRequirements, buildModelParameters);
        }
        catch (Throwable t) {
            if (result == null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)t);
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)result.addFailure(t).getBuildFailure());
        }
        return result;
    }

    private static BuildActionRunner.Result runRootBuildAction(BuildAction action, ServiceRegistry buildSessionServices, BuildActionModelRequirements buildActionRequirements, BuildModelParameters buildModelParameters) {
        BuildInvocationScopeId buildInvocationScopeId = new BuildInvocationScopeId(UniqueId.generate());
        try (BuildTreeState buildTree = new BuildTreeState(buildSessionServices, buildActionRequirements, buildModelParameters, buildInvocationScopeId);){
            BuildActionRunner.Result result = ((RootBuildLifecycleBuildActionExecutor)buildTree.getServices().get(RootBuildLifecycleBuildActionExecutor.class)).execute(action);
            return result;
        }
    }

    private BuildActionModelRequirements buildActionModelRequirementsFor(BuildAction action) {
        if (action instanceof BuildModelAction && action.isCreateModel()) {
            BuildModelAction buildModelAction = (BuildModelAction)action;
            String payload = buildModelAction.getModelName();
            return new QueryModelRequirements(action.getStartParameter(), action.isRunTasks(), this.payloadHashProvider(payload));
        }
        if (action instanceof ClientProvidedBuildAction) {
            SerializedPayload payload = ((ClientProvidedBuildAction)action).getAction();
            return new RunActionRequirements(action.getStartParameter(), action.isRunTasks(), this.payloadHashProvider(payload));
        }
        if (action instanceof ClientProvidedPhasedAction) {
            SerializedPayload payload = ((ClientProvidedPhasedAction)action).getPhasedAction();
            return new RunPhasedActionRequirements(action.getStartParameter(), action.isRunTasks(), this.payloadHashProvider(payload));
        }
        return new RunTasksRequirements(action.getStartParameter());
    }

    private Supplier<HashCode> payloadHashProvider(Object payload) {
        ValueSnapshotter valueSnapshotter = this.valueSnapshotter;
        return () -> Hashing.hashHashable((Hashable)valueSnapshotter.snapshot(payload));
    }
}

