/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.caching.CachingStateFactory;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.steps.AbstractResolveCachingStateStep;
import org.gradle.internal.execution.steps.MutableBeforeExecutionContext;
import org.gradle.internal.execution.steps.MutableCachingContext;
import org.gradle.internal.execution.steps.MutableChangesContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.UpToDateResult;
import org.gradle.internal.hash.HashCode;

public class ResolveMutableCachingStateStep<C extends MutableChangesContext>
extends AbstractResolveCachingStateStep<C> {
    private final Step<? super MutableCachingContext, ? extends UpToDateResult> delegate;

    public ResolveMutableCachingStateStep(BuildCacheController buildCache, boolean emitDebugLogging, Step<? super MutableCachingContext, ? extends UpToDateResult> delegate) {
        super(buildCache, emitDebugLogging);
        this.delegate = delegate;
    }

    @Override
    protected HashCode calculateCacheKey(C context, BeforeExecutionState beforeExecutionState, CachingStateFactory cachingStateFactory) {
        return ResolveMutableCachingStateStep.getPreviousCacheKeyIfApplicable(context).orElseGet(() -> super.calculateCacheKey(context, beforeExecutionState, cachingStateFactory));
    }

    private static Optional<HashCode> getPreviousCacheKeyIfApplicable(MutableChangesContext context) {
        return context.getChanges().flatMap(changes -> context.getPreviousExecutionState().filter(__ -> changes.getChangeDescriptions().isEmpty()).map(PreviousExecutionState::getCacheKey));
    }

    @Override
    protected void checkIfWorkIsCacheable(UnitOfWork work, C context, ImmutableList.Builder<CachingDisabledReason> cachingDisabledReasonsBuilder) {
        OverlappingOutputs detectedOverlappingOutputs = ((MutableBeforeExecutionContext)context).getDetectedOverlappingOutputs().orElse(null);
        work.shouldDisableCaching(detectedOverlappingOutputs).ifPresent(arg_0 -> cachingDisabledReasonsBuilder.add(arg_0));
    }

    @Override
    protected UpToDateResult executeDelegate(UnitOfWork work, C context, CachingState cachingState) {
        return this.delegate.execute(work, new MutableCachingContext((MutableChangesContext)context, cachingState));
    }
}

