/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.PluginIdentifier;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationFinishEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationOperationDescriptor;
import org.gradle.tooling.events.configuration.ProjectConfigurationOperationResult;
import org.gradle.tooling.events.configuration.ProjectConfigurationProgressEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationStartEvent;
import org.gradle.tooling.events.configuration.internal.DefaultPluginApplicationResult;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationFailureResult;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationFinishEvent;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationOperationDescriptor;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationStartEvent;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationSuccessResult;
import org.gradle.tooling.events.download.FileDownloadFinishEvent;
import org.gradle.tooling.events.download.FileDownloadOperationDescriptor;
import org.gradle.tooling.events.download.FileDownloadProgressEvent;
import org.gradle.tooling.events.download.FileDownloadResult;
import org.gradle.tooling.events.download.FileDownloadStartEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadFailureResult;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadFinishEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadOperationDescriptor;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadStartEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadSuccessResult;
import org.gradle.tooling.events.download.internal.NotFoundFileDownloadSuccessResult;
import org.gradle.tooling.events.internal.DefaultBinaryPluginIdentifier;
import org.gradle.tooling.events.internal.DefaultFinishEvent;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.internal.DefaultOperationFailureResult;
import org.gradle.tooling.events.internal.DefaultOperationSuccessResult;
import org.gradle.tooling.events.internal.DefaultScriptPluginIdentifier;
import org.gradle.tooling.events.internal.DefaultStartEvent;
import org.gradle.tooling.events.internal.DefaultStatusEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseFinishEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseOperationDescriptor;
import org.gradle.tooling.events.lifecycle.BuildPhaseProgressEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseStartEvent;
import org.gradle.tooling.events.lifecycle.internal.DefaultBuildPhaseFinishEvent;
import org.gradle.tooling.events.lifecycle.internal.DefaultBuildPhaseOperationDescriptor;
import org.gradle.tooling.events.lifecycle.internal.DefaultBuildPhaseStartEvent;
import org.gradle.tooling.events.problems.AdditionalData;
import org.gradle.tooling.events.problems.ContextualLabel;
import org.gradle.tooling.events.problems.Details;
import org.gradle.tooling.events.problems.DocumentationLink;
import org.gradle.tooling.events.problems.Location;
import org.gradle.tooling.events.problems.Problem;
import org.gradle.tooling.events.problems.ProblemContext;
import org.gradle.tooling.events.problems.ProblemDefinition;
import org.gradle.tooling.events.problems.ProblemEvent;
import org.gradle.tooling.events.problems.ProblemGroup;
import org.gradle.tooling.events.problems.ProblemId;
import org.gradle.tooling.events.problems.ProblemSummary;
import org.gradle.tooling.events.problems.Severity;
import org.gradle.tooling.events.problems.Solution;
import org.gradle.tooling.events.problems.internal.DefaultAdditionalData;
import org.gradle.tooling.events.problems.internal.DefaultContextualLabel;
import org.gradle.tooling.events.problems.internal.DefaultCustomAdditionalData;
import org.gradle.tooling.events.problems.internal.DefaultDetails;
import org.gradle.tooling.events.problems.internal.DefaultDocumentationLink;
import org.gradle.tooling.events.problems.internal.DefaultFileLocation;
import org.gradle.tooling.events.problems.internal.DefaultLineInFileLocation;
import org.gradle.tooling.events.problems.internal.DefaultOffsetInFileLocation;
import org.gradle.tooling.events.problems.internal.DefaultPluginIdLocation;
import org.gradle.tooling.events.problems.internal.DefaultProblem;
import org.gradle.tooling.events.problems.internal.DefaultProblemAggregation;
import org.gradle.tooling.events.problems.internal.DefaultProblemAggregationEvent;
import org.gradle.tooling.events.problems.internal.DefaultProblemDefinition;
import org.gradle.tooling.events.problems.internal.DefaultProblemGroup;
import org.gradle.tooling.events.problems.internal.DefaultProblemId;
import org.gradle.tooling.events.problems.internal.DefaultProblemSummariesEvent;
import org.gradle.tooling.events.problems.internal.DefaultProblemSummary;
import org.gradle.tooling.events.problems.internal.DefaultProblemsOperationContext;
import org.gradle.tooling.events.problems.internal.DefaultSeverity;
import org.gradle.tooling.events.problems.internal.DefaultSingleProblemEvent;
import org.gradle.tooling.events.problems.internal.DefaultSolution;
import org.gradle.tooling.events.problems.internal.DefaultTaskPathLocation;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskStartEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskFailureResult;
import org.gradle.tooling.events.task.internal.DefaultTaskFinishEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskOperationDescriptor;
import org.gradle.tooling.events.task.internal.DefaultTaskSkippedResult;
import org.gradle.tooling.events.task.internal.DefaultTaskStartEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskSuccessResult;
import org.gradle.tooling.events.task.internal.TaskExecutionDetails;
import org.gradle.tooling.events.task.internal.java.DefaultAnnotationProcessorResult;
import org.gradle.tooling.events.task.internal.java.DefaultJavaCompileTaskSuccessResult;
import org.gradle.tooling.events.task.java.JavaCompileTaskOperationResult;
import org.gradle.tooling.events.test.Destination;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestMetadataEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationResult;
import org.gradle.tooling.events.test.TestOutputDescriptor;
import org.gradle.tooling.events.test.TestOutputEvent;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.gradle.tooling.events.test.TestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultJvmTestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestFailureResult;
import org.gradle.tooling.events.test.internal.DefaultTestFileAttachmentMetadataEvent;
import org.gradle.tooling.events.test.internal.DefaultTestFinishEvent;
import org.gradle.tooling.events.test.internal.DefaultTestKeyValueMetadataEvent;
import org.gradle.tooling.events.test.internal.DefaultTestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestOutputEvent;
import org.gradle.tooling.events.test.internal.DefaultTestOutputOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestSkippedResult;
import org.gradle.tooling.events.test.internal.DefaultTestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultTestSuccessResult;
import org.gradle.tooling.events.test.internal.source.DefaultClassSource;
import org.gradle.tooling.events.test.internal.source.DefaultClasspathResourceSource;
import org.gradle.tooling.events.test.internal.source.DefaultDirectorySource;
import org.gradle.tooling.events.test.internal.source.DefaultFilePosition;
import org.gradle.tooling.events.test.internal.source.DefaultFileSource;
import org.gradle.tooling.events.test.internal.source.DefaultMethodSource;
import org.gradle.tooling.events.test.internal.source.DefaultNoSource;
import org.gradle.tooling.events.test.internal.source.DefaultOtherSource;
import org.gradle.tooling.events.test.source.FilePosition;
import org.gradle.tooling.events.test.source.TestSource;
import org.gradle.tooling.events.transform.TransformFinishEvent;
import org.gradle.tooling.events.transform.TransformOperationDescriptor;
import org.gradle.tooling.events.transform.TransformOperationResult;
import org.gradle.tooling.events.transform.TransformProgressEvent;
import org.gradle.tooling.events.transform.TransformStartEvent;
import org.gradle.tooling.events.transform.internal.DefaultTransformFailureResult;
import org.gradle.tooling.events.transform.internal.DefaultTransformFinishEvent;
import org.gradle.tooling.events.transform.internal.DefaultTransformOperationDescriptor;
import org.gradle.tooling.events.transform.internal.DefaultTransformStartEvent;
import org.gradle.tooling.events.transform.internal.DefaultTransformSuccessResult;
import org.gradle.tooling.events.work.WorkItemFinishEvent;
import org.gradle.tooling.events.work.WorkItemOperationDescriptor;
import org.gradle.tooling.events.work.WorkItemOperationResult;
import org.gradle.tooling.events.work.WorkItemProgressEvent;
import org.gradle.tooling.events.work.WorkItemStartEvent;
import org.gradle.tooling.events.work.internal.DefaultWorkItemFailureResult;
import org.gradle.tooling.events.work.internal.DefaultWorkItemFinishEvent;
import org.gradle.tooling.events.work.internal.DefaultWorkItemOperationDescriptor;
import org.gradle.tooling.events.work.internal.DefaultWorkItemStartEvent;
import org.gradle.tooling.events.work.internal.DefaultWorkItemSuccessResult;
import org.gradle.tooling.internal.consumer.DefaultFailure;
import org.gradle.tooling.internal.consumer.DefaultFileComparisonTestAssertionFailure;
import org.gradle.tooling.internal.consumer.DefaultTestAssertionFailure;
import org.gradle.tooling.internal.consumer.DefaultTestFrameworkFailure;
import org.gradle.tooling.internal.protocol.InternalBasicProblemDetailsVersion3;
import org.gradle.tooling.internal.protocol.InternalBasicProblemDetailsVersion4;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.InternalFileComparisonTestAssertionFailure;
import org.gradle.tooling.internal.protocol.InternalProblemAggregationDetailsV2;
import org.gradle.tooling.internal.protocol.InternalProblemAggregationDetailsVersion3;
import org.gradle.tooling.internal.protocol.InternalProblemContextDetails;
import org.gradle.tooling.internal.protocol.InternalProblemContextDetailsV2;
import org.gradle.tooling.internal.protocol.InternalProblemDefinition;
import org.gradle.tooling.internal.protocol.InternalProblemDetails;
import org.gradle.tooling.internal.protocol.InternalProblemEvent;
import org.gradle.tooling.internal.protocol.InternalProblemEventVersion2;
import org.gradle.tooling.internal.protocol.InternalProblemGroup;
import org.gradle.tooling.internal.protocol.InternalProblemId;
import org.gradle.tooling.internal.protocol.InternalProblemSummariesDetails;
import org.gradle.tooling.internal.protocol.InternalProblemSummary;
import org.gradle.tooling.internal.protocol.InternalTestAssertionFailure;
import org.gradle.tooling.internal.protocol.InternalTestFrameworkFailure;
import org.gradle.tooling.internal.protocol.events.InternalBinaryPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalBuildPhaseDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalFileDownloadDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalFileDownloadResult;
import org.gradle.tooling.internal.protocol.events.InternalFilePosition;
import org.gradle.tooling.internal.protocol.events.InternalIncrementalTaskResult;
import org.gradle.tooling.internal.protocol.events.InternalJavaCompileTaskOperationResult;
import org.gradle.tooling.internal.protocol.events.InternalJvmTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalNotFoundFileDownloadResult;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationResult;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalProblemDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalProjectConfigurationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProjectConfigurationResult;
import org.gradle.tooling.internal.protocol.events.InternalRootOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalScriptPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalSourceAwareTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalStatusEvent;
import org.gradle.tooling.internal.protocol.events.InternalSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskCachedResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTaskFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskSkippedResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskWithExtraInfoDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalTestFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestMetadataDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestMetadataEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestMetadataEventVersion2;
import org.gradle.tooling.internal.protocol.events.InternalTestOutputDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestOutputEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestResult;
import org.gradle.tooling.internal.protocol.events.InternalTestSkippedResult;
import org.gradle.tooling.internal.protocol.events.InternalTestStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTransformDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalWorkItemDescriptor;
import org.gradle.tooling.internal.protocol.problem.InternalAdditionalData;
import org.gradle.tooling.internal.protocol.problem.InternalBasicProblemDetails;
import org.gradle.tooling.internal.protocol.problem.InternalBasicProblemDetailsVersion2;
import org.gradle.tooling.internal.protocol.problem.InternalContextualLabel;
import org.gradle.tooling.internal.protocol.problem.InternalDetails;
import org.gradle.tooling.internal.protocol.problem.InternalDocumentationLink;
import org.gradle.tooling.internal.protocol.problem.InternalFileLocation;
import org.gradle.tooling.internal.protocol.problem.InternalLabel;
import org.gradle.tooling.internal.protocol.problem.InternalLineInFileLocation;
import org.gradle.tooling.internal.protocol.problem.InternalLocation;
import org.gradle.tooling.internal.protocol.problem.InternalOffsetInFileLocation;
import org.gradle.tooling.internal.protocol.problem.InternalPluginIdLocation;
import org.gradle.tooling.internal.protocol.problem.InternalProblemCategory;
import org.gradle.tooling.internal.protocol.problem.InternalProblemDetailsVersion2;
import org.gradle.tooling.internal.protocol.problem.InternalProxiedAdditionalData;
import org.gradle.tooling.internal.protocol.problem.InternalSeverity;
import org.gradle.tooling.internal.protocol.problem.InternalSolution;
import org.gradle.tooling.internal.protocol.problem.InternalTaskPathLocation;
import org.gradle.tooling.internal.protocol.test.source.InternalClassSource;
import org.gradle.tooling.internal.protocol.test.source.InternalClasspathResourceSource;
import org.gradle.tooling.internal.protocol.test.source.InternalDirectorySource;
import org.gradle.tooling.internal.protocol.test.source.InternalFileSource;
import org.gradle.tooling.internal.protocol.test.source.InternalMethodSource;
import org.gradle.tooling.internal.protocol.test.source.InternalMissingSource;
import org.gradle.tooling.internal.protocol.test.source.InternalTestSource;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BuildProgressListenerAdapter
implements InternalBuildProgressListener {
    private final ListenerBroadcast<ProgressListener> testProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> taskProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> buildOperationProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> workItemProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> projectConfigurationProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> transformProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> testOutputProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> testMetadataProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> fileDownloadListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> buildPhaseListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> problemListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> rootBuildListeners = new ListenerBroadcast(ProgressListener.class);
    private final Map<Object, OperationDescriptor> descriptorCache = new HashMap<Object, OperationDescriptor>();

    public BuildProgressListenerAdapter(Map<OperationType, List<ProgressListener>> listeners) {
        this.testProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.TEST));
        this.taskProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.TASK));
        this.buildOperationProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.GENERIC));
        this.workItemProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.WORK_ITEM));
        this.projectConfigurationProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.PROJECT_CONFIGURATION));
        this.transformProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.TRANSFORM));
        this.testOutputProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.TEST_OUTPUT));
        this.testMetadataProgressListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.TEST_METADATA));
        this.fileDownloadListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.FILE_DOWNLOAD));
        this.buildPhaseListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.BUILD_PHASE));
        this.problemListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.PROBLEMS));
        this.rootBuildListeners.addAll(BuildProgressListenerAdapter.getOrDefault(listeners, OperationType.ROOT));
    }

    private static List<ProgressListener> getOrDefault(Map<OperationType, List<ProgressListener>> listeners, OperationType operationType) {
        List<ProgressListener> progressListeners = listeners.get((Object)operationType);
        if (progressListeners == null) {
            return Collections.emptyList();
        }
        return progressListeners;
    }

    @Override
    public List<String> getSubscribedOperations() {
        ArrayList<String> operations = new ArrayList<String>();
        if (!this.testProgressListeners.isEmpty()) {
            operations.add("TEST_EXECUTION");
        }
        if (!this.taskProgressListeners.isEmpty()) {
            operations.add("TASK_EXECUTION");
        }
        if (!this.buildOperationProgressListeners.isEmpty()) {
            operations.add("BUILD_EXECUTION");
        }
        if (!this.workItemProgressListeners.isEmpty()) {
            operations.add("WORK_ITEM_EXECUTION");
        }
        if (!this.projectConfigurationProgressListeners.isEmpty()) {
            operations.add("PROJECT_CONFIGURATION_EXECUTION");
        }
        if (!this.transformProgressListeners.isEmpty()) {
            operations.add("TRANSFORM_EXECUTION");
        }
        if (!this.testOutputProgressListeners.isEmpty()) {
            operations.add("TEST_OUTPUT");
        }
        if (!this.testMetadataProgressListeners.isEmpty()) {
            operations.add("TEST_METADATA");
        }
        if (!this.fileDownloadListeners.isEmpty()) {
            operations.add("FILE_DOWNLOAD");
        }
        if (!this.buildPhaseListeners.isEmpty()) {
            operations.add("BUILD_PHASE");
        }
        if (!this.problemListeners.isEmpty()) {
            operations.add("PROBLEMS");
        }
        if (!this.rootBuildListeners.isEmpty()) {
            operations.add("ROOT");
        }
        return operations;
    }

    @Override
    public void onEvent(Object event) {
        if (event instanceof ProgressEvent) {
            this.broadcastProgressEvent((ProgressEvent)event);
        } else if (event instanceof InternalTestProgressEvent) {
            this.broadcastTestProgressEvent((InternalTestProgressEvent)event);
        } else if (event instanceof InternalProgressEvent) {
            this.broadcastInternalProgressEvent((InternalProgressEvent)event);
        } else {
            throw new IllegalArgumentException("Unexpected event type: " + event);
        }
    }

    private void broadcastProgressEvent(ProgressEvent event) {
        if (event instanceof TestProgressEvent) {
            ((ProgressListener)this.testProgressListeners.getSource()).statusChanged(event);
        } else if (event instanceof TaskProgressEvent) {
            ((ProgressListener)this.taskProgressListeners.getSource()).statusChanged(event);
        } else if (event instanceof WorkItemProgressEvent) {
            ((ProgressListener)this.workItemProgressListeners.getSource()).statusChanged(event);
        } else if (event instanceof ProjectConfigurationProgressEvent) {
            ((ProgressListener)this.projectConfigurationProgressListeners.getSource()).statusChanged(event);
        } else if (event instanceof TransformProgressEvent) {
            ((ProgressListener)this.transformProgressListeners.getSource()).statusChanged(event);
        } else if (event instanceof TestOutputEvent) {
            ((ProgressListener)this.testOutputProgressListeners.getSource()).statusChanged(event);
        } else if (event instanceof TestMetadataEvent) {
            ((ProgressListener)this.testMetadataProgressListeners.getSource()).statusChanged(event);
        } else if (event instanceof BuildPhaseProgressEvent) {
            ((ProgressListener)this.buildPhaseListeners.getSource()).statusChanged(event);
        } else if (event instanceof ProblemEvent) {
            ((ProgressListener)this.problemListeners.getSource()).statusChanged(event);
        } else if (event instanceof FileDownloadProgressEvent || event instanceof DefaultStatusEvent) {
            ((ProgressListener)this.fileDownloadListeners.getSource()).statusChanged(event);
        } else {
            ((ProgressListener)this.buildOperationProgressListeners.getSource()).statusChanged(event);
        }
    }

    private void broadcastTestProgressEvent(InternalTestProgressEvent event) {
        TestProgressEvent testProgressEvent = this.toTestProgressEvent(event);
        if (testProgressEvent != null) {
            ((ProgressListener)this.testProgressListeners.getSource()).statusChanged(testProgressEvent);
        }
    }

    private void broadcastInternalProgressEvent(InternalProgressEvent progressEvent) {
        InternalOperationDescriptor descriptor = progressEvent.getDescriptor();
        if (descriptor instanceof InternalTaskDescriptor) {
            this.broadcastTaskProgressEvent(progressEvent, (InternalTaskDescriptor)descriptor);
        } else if (descriptor instanceof InternalWorkItemDescriptor) {
            this.broadcastWorkItemProgressEvent(progressEvent, (InternalWorkItemDescriptor)descriptor);
        } else if (descriptor instanceof InternalProjectConfigurationDescriptor) {
            this.broadcastProjectConfigurationProgressEvent(progressEvent, (InternalProjectConfigurationDescriptor)descriptor);
        } else if (descriptor instanceof InternalTransformDescriptor) {
            this.broadcastTransformProgressEvent(progressEvent, (InternalTransformDescriptor)descriptor);
        } else if (descriptor instanceof InternalTestOutputDescriptor) {
            this.broadcastTestOutputEvent(progressEvent, (InternalTestOutputDescriptor)descriptor);
        } else if (descriptor instanceof InternalTestMetadataDescriptor) {
            this.broadcastTestMetadataEvent(progressEvent, (InternalTestMetadataDescriptor)descriptor);
        } else if (descriptor instanceof InternalFileDownloadDescriptor) {
            if (progressEvent instanceof InternalStatusEvent) {
                this.broadcastStatusEvent((InternalStatusEvent)progressEvent);
            } else {
                this.broadcastFileDownloadEvent(progressEvent, (InternalFileDownloadDescriptor)descriptor);
            }
        } else if (descriptor instanceof InternalBuildPhaseDescriptor) {
            this.broadcastBuildPhaseEvent(progressEvent, (InternalBuildPhaseDescriptor)descriptor);
        } else if (descriptor instanceof InternalProblemDescriptor) {
            this.broadcastProblemEvent(progressEvent, (InternalProblemDescriptor)descriptor);
        } else if (descriptor instanceof InternalRootOperationDescriptor) {
            this.broadcastRootBuildEvent(progressEvent);
        } else {
            this.broadcastGenericProgressEvent(progressEvent);
        }
    }

    private void broadcastStatusEvent(InternalStatusEvent progressEvent) {
        OperationDescriptor descriptor = this.descriptorCache.get(progressEvent.getDescriptor().getId());
        if (descriptor == null) {
            throw new IllegalStateException(String.format("No operation with id %s in progress.", progressEvent.getDescriptor().getId()));
        }
        ((ProgressListener)this.fileDownloadListeners.getSource()).statusChanged(new DefaultStatusEvent(progressEvent.getEventTime(), descriptor, progressEvent.getTotal(), progressEvent.getProgress(), progressEvent.getUnits()));
    }

    private void broadcastTaskProgressEvent(InternalProgressEvent event, InternalTaskDescriptor descriptor) {
        TaskProgressEvent taskProgressEvent = this.toTaskProgressEvent(event, descriptor);
        if (taskProgressEvent != null) {
            ((ProgressListener)this.taskProgressListeners.getSource()).statusChanged(taskProgressEvent);
        }
    }

    private void broadcastWorkItemProgressEvent(InternalProgressEvent event, InternalWorkItemDescriptor descriptor) {
        WorkItemProgressEvent workItemProgressEvent = this.toWorkItemProgressEvent(event, descriptor);
        if (workItemProgressEvent != null) {
            ((ProgressListener)this.workItemProgressListeners.getSource()).statusChanged(workItemProgressEvent);
        }
    }

    private void broadcastProjectConfigurationProgressEvent(InternalProgressEvent event, InternalProjectConfigurationDescriptor descriptor) {
        ProjectConfigurationProgressEvent projectConfigurationProgressEvent = this.toProjectConfigurationProgressEvent(event, descriptor);
        if (projectConfigurationProgressEvent != null) {
            ((ProgressListener)this.projectConfigurationProgressListeners.getSource()).statusChanged(projectConfigurationProgressEvent);
        }
    }

    private void broadcastTransformProgressEvent(InternalProgressEvent event, InternalTransformDescriptor descriptor) {
        TransformProgressEvent transformProgressEvent = this.toTransformProgressEvent(event, descriptor);
        if (transformProgressEvent != null) {
            ((ProgressListener)this.transformProgressListeners.getSource()).statusChanged(transformProgressEvent);
        }
    }

    private void broadcastTestOutputEvent(InternalProgressEvent event, InternalTestOutputDescriptor descriptor) {
        TestOutputEvent outputEvent = this.toTestOutputEvent(event, descriptor);
        if (outputEvent != null) {
            ((ProgressListener)this.testOutputProgressListeners.getSource()).statusChanged(outputEvent);
        }
    }

    private void broadcastTestMetadataEvent(InternalProgressEvent event, InternalTestMetadataDescriptor descriptor) {
        TestMetadataEvent metadataEvent = this.toTestMetadataEvent(event, descriptor);
        if (metadataEvent != null) {
            ((ProgressListener)this.testMetadataProgressListeners.getSource()).statusChanged(metadataEvent);
        }
    }

    private void broadcastProblemEvent(InternalProgressEvent progressEvent, InternalProblemDescriptor descriptor) {
        ProblemEvent problemEvent = this.toProblemEvent(progressEvent, descriptor);
        if (problemEvent != null) {
            ((ProgressListener)this.problemListeners.getSource()).statusChanged(problemEvent);
        }
    }

    private void broadcastRootBuildEvent(InternalProgressEvent event) {
        ProgressEvent progressEvent = this.toGenericProgressEvent(event);
        if (progressEvent != null) {
            ((ProgressListener)this.rootBuildListeners.getSource()).statusChanged(progressEvent);
        }
    }

    private void broadcastFileDownloadEvent(InternalProgressEvent event, InternalFileDownloadDescriptor descriptor) {
        FileDownloadProgressEvent progressEvent = this.toFileDownloadProgressEvent(event, descriptor);
        if (progressEvent != null) {
            ((ProgressListener)this.fileDownloadListeners.getSource()).statusChanged(progressEvent);
        }
    }

    private void broadcastBuildPhaseEvent(InternalProgressEvent event, InternalBuildPhaseDescriptor descriptor) {
        BuildPhaseProgressEvent progressEvent = this.toBuildPhaseEvent(event, descriptor);
        if (progressEvent != null) {
            ((ProgressListener)this.buildPhaseListeners.getSource()).statusChanged(progressEvent);
        }
    }

    private @Nullable BuildPhaseProgressEvent toBuildPhaseEvent(InternalProgressEvent event, InternalBuildPhaseDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.buildPhaseStartEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.buildPhaseFinishEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private BuildPhaseStartEvent buildPhaseStartEvent(InternalOperationStartedProgressEvent event, InternalBuildPhaseDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        BuildPhaseOperationDescriptor newDescriptor = this.addDescriptor(event.getDescriptor(), new DefaultBuildPhaseOperationDescriptor(descriptor, parent));
        return new DefaultBuildPhaseStartEvent(event.getEventTime(), event.getDisplayName(), newDescriptor);
    }

    private BuildPhaseFinishEvent buildPhaseFinishEvent(InternalOperationFinishedProgressEvent event) {
        OperationResult result;
        BuildPhaseOperationDescriptor descriptor = this.removeDescriptor(BuildPhaseOperationDescriptor.class, event.getDescriptor());
        if (event.getResult() instanceof InternalFailureResult) {
            InternalFailureResult internalResult = (InternalFailureResult)event.getResult();
            result = new DefaultOperationFailureResult(internalResult.getStartTime(), internalResult.getEndTime(), BuildProgressListenerAdapter.toFailures(internalResult.getFailures()));
        } else {
            result = new DefaultOperationSuccessResult(event.getResult().getStartTime(), event.getResult().getEndTime());
        }
        return new DefaultBuildPhaseFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, result);
    }

    private void broadcastGenericProgressEvent(InternalProgressEvent event) {
        ProgressEvent progressEvent = this.toGenericProgressEvent(event);
        if (progressEvent != null) {
            ((ProgressListener)this.buildOperationProgressListeners.getSource()).statusChanged(progressEvent);
        }
    }

    private @Nullable TestProgressEvent toTestProgressEvent(InternalTestProgressEvent event) {
        if (event instanceof InternalTestStartedProgressEvent) {
            return this.testStartedEvent((InternalTestStartedProgressEvent)event);
        }
        if (event instanceof InternalTestFinishedProgressEvent) {
            return this.testFinishedEvent((InternalTestFinishedProgressEvent)event);
        }
        return null;
    }

    private @Nullable TaskProgressEvent toTaskProgressEvent(InternalProgressEvent event, InternalTaskDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.taskStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.taskFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private @Nullable WorkItemProgressEvent toWorkItemProgressEvent(InternalProgressEvent event, InternalWorkItemDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.workItemStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.workItemFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private @Nullable ProjectConfigurationProgressEvent toProjectConfigurationProgressEvent(InternalProgressEvent event, InternalProjectConfigurationDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.projectConfigurationStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.projectConfigurationFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private @Nullable TransformProgressEvent toTransformProgressEvent(InternalProgressEvent event, InternalTransformDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.transformStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.transformFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private @Nullable FileDownloadProgressEvent toFileDownloadProgressEvent(InternalProgressEvent event, InternalFileDownloadDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.fileDownloadStartEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.fileDownloadFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private @Nullable TestOutputEvent toTestOutputEvent(InternalProgressEvent event, InternalTestOutputDescriptor descriptor) {
        if (event instanceof InternalTestOutputEvent) {
            return this.transformTestOutput((InternalTestOutputEvent)event, descriptor);
        }
        return null;
    }

    private TestOutputEvent transformTestOutput(InternalTestOutputEvent event, InternalTestOutputDescriptor descriptor) {
        TestOutputDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTestOutputDescriptor(event, descriptor));
        return new DefaultTestOutputEvent(event.getEventTime(), clientDescriptor);
    }

    private @Nullable TestMetadataEvent toTestMetadataEvent(InternalProgressEvent event, InternalTestMetadataDescriptor descriptor) {
        if (event instanceof InternalTestMetadataEventVersion2) {
            OperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toDescriptor(descriptor));
            return new DefaultTestFileAttachmentMetadataEvent(event.getEventTime(), clientDescriptor, ((InternalTestMetadataEventVersion2)event).getFile(), ((InternalTestMetadataEventVersion2)event).getMediaType());
        }
        if (event instanceof InternalTestMetadataEvent) {
            OperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toDescriptor(descriptor));
            Map<String, Object> values = ((InternalTestMetadataEvent)event).getValues();
            LinkedHashMap<String, String> keyValues = new LinkedHashMap<String, String>();
            values.forEach((key, value) -> keyValues.put((String)key, String.valueOf(value)));
            return new DefaultTestKeyValueMetadataEvent(event.getEventTime(), clientDescriptor, keyValues);
        }
        return null;
    }

    private @Nullable ProblemEvent toProblemEvent(InternalProgressEvent progressEvent, InternalProblemDescriptor descriptor) {
        if (progressEvent instanceof InternalProblemEvent) {
            InternalProblemEvent problemEvent = (InternalProblemEvent)progressEvent;
            return this.createProblemEvent(problemEvent, descriptor);
        }
        if (progressEvent instanceof InternalProblemEventVersion2) {
            InternalProblemEventVersion2 problemEvent = (InternalProblemEventVersion2)progressEvent;
            return this.createProblemEvent(problemEvent, descriptor);
        }
        return null;
    }

    private @Nullable ProblemEvent createProblemEvent(InternalProblemEvent problemEvent, InternalProblemDescriptor descriptor) {
        InternalProblemDetails details = problemEvent.getDetails();
        OperationDescriptor parentDescriptor = this.getParentDescriptor(descriptor.getParentId());
        if (details instanceof InternalBasicProblemDetails) {
            InternalBasicProblemDetails basicProblemDetails = (InternalBasicProblemDetails)details;
            return new DefaultSingleProblemEvent(problemEvent.getEventTime(), parentDescriptor, BuildProgressListenerAdapter.toProblem(basicProblemDetails));
        }
        if (details instanceof InternalProblemAggregationDetailsV2) {
            InternalProblemAggregationDetailsV2 problemAggregationDetails = (InternalProblemAggregationDetailsV2)details;
            return new DefaultProblemAggregationEvent(problemEvent.getEventTime(), parentDescriptor, new DefaultProblemAggregation(BuildProgressListenerAdapter.toProblemDefinition(problemAggregationDetails.getLabel(), problemAggregationDetails.getCategory(), problemAggregationDetails.getSeverity(), problemAggregationDetails.getDocumentationLink()), BuildProgressListenerAdapter.toProblemContextDetails(problemAggregationDetails.getProblems())));
        }
        return null;
    }

    static @NonNull List<ProblemSummary> toProblemIdSummaries(List<InternalProblemSummary> problemIdCounts) {
        Map<ProblemId, List<InternalProblemSummary>> groupedSummaries = BuildProgressListenerAdapter.getGroupedMap(problemIdCounts);
        ArrayList<ProblemSummary> problemSummaries = new ArrayList<ProblemSummary>();
        for (Map.Entry<ProblemId, List<InternalProblemSummary>> groupEntry : groupedSummaries.entrySet()) {
            problemSummaries.add(new DefaultProblemSummary(groupEntry.getKey(), BuildProgressListenerAdapter.getCount(groupEntry)));
        }
        return problemSummaries;
    }

    static @NonNull Map<ProblemId, List<InternalProblemSummary>> getGroupedMap(List<InternalProblemSummary> problemIdCounts) {
        HashMap<ProblemId, List<InternalProblemSummary>> groupedSummaries = new HashMap<ProblemId, List<InternalProblemSummary>>();
        for (InternalProblemSummary internalSummary : problemIdCounts) {
            ProblemId problemId = BuildProgressListenerAdapter.toProblemId(internalSummary.getProblemId());
            BuildProgressListenerAdapter.getOrDefault(groupedSummaries, problemId).add(internalSummary);
        }
        return groupedSummaries;
    }

    private static @NonNull List<InternalProblemSummary> getOrDefault(Map<ProblemId, List<InternalProblemSummary>> groupedSummaries, ProblemId problemId) {
        List<InternalProblemSummary> internalProblemSummaries = groupedSummaries.get(problemId);
        if (internalProblemSummaries == null) {
            internalProblemSummaries = new ArrayList<InternalProblemSummary>();
            groupedSummaries.put(problemId, internalProblemSummaries);
        }
        return internalProblemSummaries;
    }

    static int getCount(Map.Entry<ProblemId, List<InternalProblemSummary>> groupEntry) {
        int count = 0;
        for (InternalProblemSummary internalProblemSummary : groupEntry.getValue()) {
            count += internalProblemSummary.getCount().intValue();
        }
        return count;
    }

    private @Nullable ProblemEvent createProblemEvent(InternalProblemEventVersion2 problemEvent, InternalProblemDescriptor descriptor) {
        InternalProblemDetailsVersion2 details = problemEvent.getDetails();
        OperationDescriptor parentDescriptor = this.getParentDescriptor(descriptor.getParentId());
        if (details instanceof InternalBasicProblemDetailsVersion3) {
            InternalBasicProblemDetailsVersion3 basicProblemDetails = (InternalBasicProblemDetailsVersion3)details;
            return new DefaultSingleProblemEvent(problemEvent.getEventTime(), parentDescriptor, BuildProgressListenerAdapter.toProblem(basicProblemDetails));
        }
        if (details instanceof InternalProblemAggregationDetailsVersion3) {
            InternalProblemAggregationDetailsVersion3 problemAggregationDetails = (InternalProblemAggregationDetailsVersion3)details;
            return new DefaultProblemAggregationEvent(problemEvent.getEventTime(), parentDescriptor, new DefaultProblemAggregation(BuildProgressListenerAdapter.toProblemDefinition(problemAggregationDetails.getDefinition()), BuildProgressListenerAdapter.toProblemContextDetails(problemAggregationDetails.getProblems())));
        }
        if (details instanceof InternalProblemSummariesDetails) {
            InternalProblemSummariesDetails problemSummariesDetails = (InternalProblemSummariesDetails)details;
            return new DefaultProblemSummariesEvent(problemEvent.getEventTime(), parentDescriptor, BuildProgressListenerAdapter.toProblemIdSummaries(problemSummariesDetails.getProblemIdCounts()));
        }
        return null;
    }

    private static @NonNull DefaultProblemsOperationContext toSingleProblemContextDetail(InternalProblemContextDetails details) {
        if (details instanceof InternalProblemContextDetailsV2) {
            InternalProblemContextDetailsV2 detailsV2 = (InternalProblemContextDetailsV2)details;
            return new DefaultProblemsOperationContext(BuildProgressListenerAdapter.toProblemDetails(detailsV2.getDetails()), BuildProgressListenerAdapter.toLocations(detailsV2.getOriginLocations()), BuildProgressListenerAdapter.toLocations(detailsV2.getContextualLocations()), BuildProgressListenerAdapter.toSolutions(detailsV2.getSolutions()), BuildProgressListenerAdapter.toAdditionalData(detailsV2.getAdditionalData()), BuildProgressListenerAdapter.toFailure(detailsV2.getFailure()));
        }
        return new DefaultProblemsOperationContext(BuildProgressListenerAdapter.toProblemDetails(details.getDetails()), BuildProgressListenerAdapter.toLocations(details.getLocations()), (List<Location>)ImmutableList.of(), BuildProgressListenerAdapter.toSolutions(details.getSolutions()), BuildProgressListenerAdapter.toAdditionalData(details.getAdditionalData()), BuildProgressListenerAdapter.toFailure(details.getFailure()));
    }

    private static List<ProblemContext> toProblemContextDetails(List<InternalProblemContextDetails> problems) {
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)problems.size());
        for (InternalProblemContextDetails problem : problems) {
            result.add((Object)BuildProgressListenerAdapter.toSingleProblemContextDetail(problem));
        }
        return result.build();
    }

    private @Nullable ProgressEvent toGenericProgressEvent(InternalProgressEvent event) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.genericStartedEvent((InternalOperationStartedProgressEvent)event);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.genericFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private TestStartEvent testStartedEvent(InternalTestStartedProgressEvent event) {
        TestOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTestDescriptor(event.getDescriptor()));
        return new DefaultTestStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private TaskStartEvent taskStartedEvent(InternalOperationStartedProgressEvent event, InternalTaskDescriptor descriptor) {
        TaskOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTaskDescriptor(descriptor));
        return new DefaultTaskStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private WorkItemStartEvent workItemStartedEvent(InternalOperationStartedProgressEvent event, InternalWorkItemDescriptor descriptor) {
        WorkItemOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toWorkItemDescriptor(descriptor));
        return new DefaultWorkItemStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private ProjectConfigurationStartEvent projectConfigurationStartedEvent(InternalOperationStartedProgressEvent event, InternalProjectConfigurationDescriptor descriptor) {
        ProjectConfigurationOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toProjectConfigurationDescriptor(descriptor));
        return new DefaultProjectConfigurationStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private TransformStartEvent transformStartedEvent(InternalOperationStartedProgressEvent event, InternalTransformDescriptor descriptor) {
        TransformOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTransformDescriptor(descriptor));
        return new DefaultTransformStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private FileDownloadStartEvent fileDownloadStartEvent(InternalOperationStartedProgressEvent event, InternalFileDownloadDescriptor descriptor) {
        FileDownloadOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toFileDownloadDescriptor(descriptor));
        return new DefaultFileDownloadStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private StartEvent genericStartedEvent(InternalOperationStartedProgressEvent event) {
        OperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toDescriptor(event.getDescriptor()));
        return new DefaultStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private TestFinishEvent testFinishedEvent(InternalTestFinishedProgressEvent event) {
        TestOperationDescriptor clientDescriptor = this.removeDescriptor(TestOperationDescriptor.class, event.getDescriptor());
        return new DefaultTestFinishEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor, BuildProgressListenerAdapter.toTestResult(event.getResult()));
    }

    private TaskFinishEvent taskFinishedEvent(InternalOperationFinishedProgressEvent event) {
        TaskOperationDescriptor descriptor = BuildProgressListenerAdapter.assertDescriptorType(TaskOperationDescriptor.class, this.getParentDescriptor(event.getDescriptor().getId()));
        return new DefaultTaskFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toTaskResult((InternalTaskResult)event.getResult()));
    }

    private WorkItemFinishEvent workItemFinishedEvent(InternalOperationFinishedProgressEvent event) {
        WorkItemOperationDescriptor descriptor = this.removeDescriptor(WorkItemOperationDescriptor.class, event.getDescriptor());
        return new DefaultWorkItemFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toWorkItemResult(event.getResult()));
    }

    private ProjectConfigurationFinishEvent projectConfigurationFinishedEvent(InternalOperationFinishedProgressEvent event) {
        ProjectConfigurationOperationDescriptor descriptor = this.removeDescriptor(ProjectConfigurationOperationDescriptor.class, event.getDescriptor());
        return new DefaultProjectConfigurationFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toProjectConfigurationResult((InternalProjectConfigurationResult)event.getResult()));
    }

    private TransformFinishEvent transformFinishedEvent(InternalOperationFinishedProgressEvent event) {
        TransformOperationDescriptor descriptor = BuildProgressListenerAdapter.assertDescriptorType(TransformOperationDescriptor.class, this.getParentDescriptor(event.getDescriptor().getId()));
        return new DefaultTransformFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toTransformResult(event.getResult()));
    }

    private FileDownloadFinishEvent fileDownloadFinishedEvent(InternalOperationFinishedProgressEvent event) {
        FileDownloadOperationDescriptor descriptor = this.removeDescriptor(FileDownloadOperationDescriptor.class, event.getDescriptor());
        return new DefaultFileDownloadFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toFileDownloadResult(event.getResult()));
    }

    private FinishEvent genericFinishedEvent(InternalOperationFinishedProgressEvent event) {
        OperationDescriptor descriptor = this.removeDescriptor(OperationDescriptor.class, event.getDescriptor());
        return new DefaultFinishEvent<OperationDescriptor, OperationResult>(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toResult(event.getResult()));
    }

    private synchronized <T extends OperationDescriptor> T addDescriptor(InternalOperationDescriptor descriptor, T clientDescriptor) {
        if (this.descriptorCache.containsKey(descriptor.getId())) {
            throw new IllegalStateException(String.format("Operation %s already available.", descriptor));
        }
        this.descriptorCache.put(descriptor.getId(), clientDescriptor);
        return clientDescriptor;
    }

    private synchronized <T extends OperationDescriptor> T removeDescriptor(Class<T> type, InternalOperationDescriptor descriptor) {
        OperationDescriptor cachedTestDescriptor = this.descriptorCache.remove(descriptor.getId());
        if (cachedTestDescriptor == null) {
            throw new IllegalStateException(String.format("Operation %s is not available.", descriptor));
        }
        return BuildProgressListenerAdapter.assertDescriptorType(type, cachedTestDescriptor);
    }

    private static <T extends OperationDescriptor> T assertDescriptorType(Class<T> type, OperationDescriptor descriptor) {
        Class<?> descriptorClass = descriptor.getClass();
        if (!type.isAssignableFrom(descriptorClass)) {
            throw new IllegalStateException(String.format("Unexpected operation type. Required %s but found %s", type.getName(), descriptorClass.getName()));
        }
        return (T)((OperationDescriptor)Cast.uncheckedNonnullCast((Object)descriptor));
    }

    private TestOperationDescriptor toTestDescriptor(InternalTestDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        if (descriptor instanceof InternalSourceAwareTestDescriptor) {
            TestSource testSource = BuildProgressListenerAdapter.toTestSource((InternalSourceAwareTestDescriptor)descriptor);
            InternalSourceAwareTestDescriptor jvmTestDescriptor = (InternalSourceAwareTestDescriptor)descriptor;
            return new DefaultJvmTestOperationDescriptor(jvmTestDescriptor, parent, BuildProgressListenerAdapter.toJvmTestKind(jvmTestDescriptor.getTestKind()), jvmTestDescriptor.getSuiteName(), jvmTestDescriptor.getClassName(), jvmTestDescriptor.getMethodName(), testSource);
        }
        if (descriptor instanceof InternalJvmTestDescriptor) {
            InternalJvmTestDescriptor jvmTestDescriptor = (InternalJvmTestDescriptor)descriptor;
            TestSource testSource = BuildProgressListenerAdapter.inferLegacyTestSource(jvmTestDescriptor);
            return new DefaultJvmTestOperationDescriptor(jvmTestDescriptor, parent, BuildProgressListenerAdapter.toJvmTestKind(jvmTestDescriptor.getTestKind()), jvmTestDescriptor.getSuiteName(), jvmTestDescriptor.getClassName(), jvmTestDescriptor.getMethodName(), testSource);
        }
        return new DefaultTestOperationDescriptor(descriptor, parent);
    }

    private static TestSource inferLegacyTestSource(InternalJvmTestDescriptor descriptor) {
        if (descriptor.getClassName() != null && descriptor.getMethodName() != null) {
            return new DefaultMethodSource(descriptor.getClassName(), descriptor.getMethodName());
        }
        if (descriptor.getClassName() != null && descriptor.getMethodName() == null) {
            return new DefaultClassSource(descriptor.getClassName());
        }
        return DefaultNoSource.getInstance();
    }

    private static TestSource toTestSource(InternalSourceAwareTestDescriptor descriptor) {
        InternalTestSource testSource = descriptor.getSource();
        return BuildProgressListenerAdapter.toTestSource(testSource);
    }

    private static TestSource toTestSource(InternalTestSource testSource) {
        if (testSource instanceof InternalFileSource) {
            InternalFileSource fileSource = (InternalFileSource)testSource;
            return new DefaultFileSource(fileSource.getFile(), BuildProgressListenerAdapter.toFilePosition(((InternalFileSource)testSource).getPosition()));
        }
        if (testSource instanceof InternalDirectorySource) {
            return new DefaultDirectorySource(((InternalDirectorySource)testSource).getFile());
        }
        if (testSource instanceof InternalClassSource) {
            InternalClassSource classSource = (InternalClassSource)testSource;
            return new DefaultClassSource(classSource.getClassName());
        }
        if (testSource instanceof InternalMethodSource) {
            InternalMethodSource methodSource = (InternalMethodSource)testSource;
            return new DefaultMethodSource(methodSource.getClassName(), methodSource.getMethodName());
        }
        if (testSource instanceof InternalClasspathResourceSource) {
            InternalClasspathResourceSource classpathResourceSource = (InternalClasspathResourceSource)testSource;
            return new DefaultClasspathResourceSource(classpathResourceSource.getClasspathResourceName(), BuildProgressListenerAdapter.toFilePosition(classpathResourceSource.getPosition()));
        }
        if (testSource instanceof InternalMissingSource) {
            return DefaultNoSource.getInstance();
        }
        return DefaultOtherSource.getInstance();
    }

    private static FilePosition toFilePosition(@Nullable InternalFilePosition position) {
        if (position == null) {
            return null;
        }
        return new DefaultFilePosition(position.getLine(), position.getColumn());
    }

    private static JvmTestKind toJvmTestKind(String testKind) {
        if ("SUITE".equals(testKind)) {
            return JvmTestKind.SUITE;
        }
        if ("ATOMIC".equals(testKind)) {
            return JvmTestKind.ATOMIC;
        }
        return JvmTestKind.UNKNOWN;
    }

    private TaskOperationDescriptor toTaskDescriptor(InternalTaskDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        if (descriptor instanceof InternalTaskWithExtraInfoDescriptor) {
            InternalTaskWithExtraInfoDescriptor descriptorWithExtras = (InternalTaskWithExtraInfoDescriptor)descriptor;
            Set<OperationDescriptor> dependencies = this.collectDescriptors(descriptorWithExtras.getDependencies());
            PluginIdentifier originPlugin = BuildProgressListenerAdapter.toPluginIdentifier(descriptorWithExtras.getOriginPlugin());
            return new DefaultTaskOperationDescriptor(descriptor, parent, descriptor.getTaskPath(), dependencies, originPlugin);
        }
        return new DefaultTaskOperationDescriptor(descriptor, parent, descriptor.getTaskPath());
    }

    private WorkItemOperationDescriptor toWorkItemDescriptor(InternalWorkItemDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultWorkItemOperationDescriptor(descriptor, parent);
    }

    private ProjectConfigurationOperationDescriptor toProjectConfigurationDescriptor(InternalProjectConfigurationDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultProjectConfigurationOperationDescriptor(descriptor, parent);
    }

    private TransformOperationDescriptor toTransformDescriptor(InternalTransformDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultTransformOperationDescriptor(descriptor, parent, this.collectDescriptors(descriptor.getDependencies()));
    }

    private FileDownloadOperationDescriptor toFileDownloadDescriptor(InternalFileDownloadDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultFileDownloadOperationDescriptor(descriptor, parent);
    }

    private TestOutputDescriptor toTestOutputDescriptor(InternalTestOutputEvent event, InternalTestOutputDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        Destination destination = Destination.fromCode(event.getResult().getDestination());
        String message = event.getResult().getMessage();
        return new DefaultTestOutputOperationDescriptor(descriptor, parent, destination, message);
    }

    private static Problem toProblem(InternalBasicProblemDetails basicProblemDetails) {
        return new DefaultProblem(BuildProgressListenerAdapter.toProblemDefinition(basicProblemDetails.getLabel(), basicProblemDetails.getCategory(), basicProblemDetails.getSeverity(), basicProblemDetails.getDocumentationLink()), BuildProgressListenerAdapter.toContextualLabel(basicProblemDetails.getLabel().getLabel()), BuildProgressListenerAdapter.toProblemDetails(basicProblemDetails.getDetails()), BuildProgressListenerAdapter.toLocations(basicProblemDetails.getLocations()), Collections.emptyList(), BuildProgressListenerAdapter.toSolutions(basicProblemDetails.getSolutions()), BuildProgressListenerAdapter.toAdditionalData(basicProblemDetails.getAdditionalData()), BuildProgressListenerAdapter.toFailure(basicProblemDetails));
    }

    private static Problem toProblem(InternalBasicProblemDetailsVersion3 basicProblemDetails) {
        List<InternalLocation> contextualLocations;
        List<InternalLocation> originLocations;
        if (basicProblemDetails instanceof InternalBasicProblemDetailsVersion4) {
            originLocations = ((InternalBasicProblemDetailsVersion4)basicProblemDetails).getOriginLocations();
            contextualLocations = ((InternalBasicProblemDetailsVersion4)basicProblemDetails).getContextualLocations();
        } else {
            originLocations = basicProblemDetails.getLocations();
            contextualLocations = Collections.emptyList();
        }
        return new DefaultProblem(BuildProgressListenerAdapter.toProblemDefinition(basicProblemDetails.getDefinition()), BuildProgressListenerAdapter.toContextualLabel(basicProblemDetails.getContextualLabel()), BuildProgressListenerAdapter.toProblemDetails(basicProblemDetails.getDetails()), BuildProgressListenerAdapter.toLocations(originLocations), BuildProgressListenerAdapter.toLocations(contextualLocations), BuildProgressListenerAdapter.toSolutions(basicProblemDetails.getSolutions()), BuildProgressListenerAdapter.toAdditionalData(basicProblemDetails.getAdditionalData()), BuildProgressListenerAdapter.toFailure(basicProblemDetails.getFailure()));
    }

    private static ProblemDefinition toProblemDefinition(InternalProblemDefinition problemDefinition) {
        return new DefaultProblemDefinition(BuildProgressListenerAdapter.toProblemId(problemDefinition.getId()), BuildProgressListenerAdapter.toProblemSeverity(problemDefinition.getSeverity()), BuildProgressListenerAdapter.toDocumentationLink(problemDefinition.getDocumentationLink()));
    }

    private static ProblemDefinition toProblemDefinition(InternalLabel label, InternalProblemCategory category, InternalSeverity severity, @Nullable InternalDocumentationLink documentationLink) {
        return new DefaultProblemDefinition(BuildProgressListenerAdapter.toProblemId(label, category), BuildProgressListenerAdapter.toProblemSeverity(severity), BuildProgressListenerAdapter.toDocumentationLink(documentationLink));
    }

    private static ProblemId toProblemId(InternalProblemId problemId) {
        return new DefaultProblemId(problemId.getName(), problemId.getDisplayName(), BuildProgressListenerAdapter.toProblemGroup(problemId.getGroup()));
    }

    private static ProblemId toProblemId(InternalLabel label, InternalProblemCategory category) {
        ArrayList<String> categories = new ArrayList<String>();
        categories.add(category.getCategory());
        categories.addAll(category.getSubcategories());
        return new DefaultProblemId((String)categories.remove(categories.size() - 1), label.getLabel(), BuildProgressListenerAdapter.toProblemGroup(categories));
    }

    private static @Nullable ProblemGroup toProblemGroup(List<String> groupNames) {
        if (groupNames.isEmpty()) {
            return null;
        }
        String groupName = groupNames.remove(groupNames.size() - 1);
        return new DefaultProblemGroup(groupName, groupName, BuildProgressListenerAdapter.toProblemGroup(groupNames));
    }

    private static ProblemGroup toProblemGroup(InternalProblemGroup problemGroup) {
        return new DefaultProblemGroup(problemGroup.getName(), problemGroup.getDisplayName(), problemGroup.getParent() == null ? null : BuildProgressListenerAdapter.toProblemGroup(problemGroup.getParent()));
    }

    private static AdditionalData toAdditionalData(InternalAdditionalData additionalData) {
        if (additionalData instanceof InternalProxiedAdditionalData) {
            Object proxy = ((InternalProxiedAdditionalData)additionalData).getProxy();
            return new DefaultCustomAdditionalData(additionalData.getAsMap(), proxy);
        }
        if (additionalData == null) {
            return new DefaultAdditionalData(Collections.emptyMap());
        }
        return new DefaultAdditionalData(additionalData.getAsMap());
    }

    private static @Nullable ContextualLabel toContextualLabel(@Nullable InternalContextualLabel contextualLabel) {
        return contextualLabel == null ? null : new DefaultContextualLabel(contextualLabel.getContextualLabel());
    }

    private static ContextualLabel toContextualLabel(@Nullable String contextualLabel) {
        return contextualLabel == null ? null : new DefaultContextualLabel(contextualLabel);
    }

    private static Severity toProblemSeverity(InternalSeverity severity) {
        return DefaultSeverity.from(severity != null ? severity.getSeverity() : Severity.WARNING.getSeverity());
    }

    private static List<Location> toLocations(List<InternalLocation> locations) {
        ArrayList<Location> result = new ArrayList<Location>(locations.size());
        for (InternalLocation location : locations) {
            InternalFileLocation l;
            if (location instanceof InternalLineInFileLocation) {
                l = (InternalLineInFileLocation)location;
                result.add(new DefaultLineInFileLocation(l.getPath(), l.getLine(), l.getColumn(), l.getLength()));
                continue;
            }
            if (location instanceof InternalOffsetInFileLocation) {
                l = (InternalOffsetInFileLocation)location;
                result.add(new DefaultOffsetInFileLocation(l.getPath(), l.getOffset(), l.getLength()));
                continue;
            }
            if (location instanceof InternalFileLocation) {
                l = (InternalFileLocation)location;
                result.add(new DefaultFileLocation(l.getPath()));
                continue;
            }
            if (location instanceof InternalPluginIdLocation) {
                InternalPluginIdLocation pluginLocation = (InternalPluginIdLocation)location;
                result.add(new DefaultPluginIdLocation(pluginLocation.getPluginId()));
                continue;
            }
            if (!(location instanceof InternalTaskPathLocation)) continue;
            InternalTaskPathLocation taskLocation = (InternalTaskPathLocation)location;
            result.add(new DefaultTaskPathLocation(taskLocation.getBuildTreePath()));
        }
        return result;
    }

    private static DocumentationLink toDocumentationLink(@Nullable InternalDocumentationLink link) {
        return link == null || link.getUrl() == null ? null : new DefaultDocumentationLink(link.getUrl());
    }

    private static List<Solution> toSolutions(List<InternalSolution> solutions) {
        ArrayList<Solution> result = new ArrayList<Solution>(solutions.size());
        for (InternalSolution solution : solutions) {
            result.add(new DefaultSolution(solution.getSolution()));
        }
        return result;
    }

    private static Details toProblemDetails(@Nullable InternalDetails details) {
        if (details != null) {
            return new DefaultDetails(details.getDetails());
        }
        return null;
    }

    private Set<OperationDescriptor> collectDescriptors(Set<? extends InternalOperationDescriptor> dependencies) {
        LinkedHashSet<OperationDescriptor> result = new LinkedHashSet<OperationDescriptor>();
        for (InternalOperationDescriptor internalOperationDescriptor : dependencies) {
            OperationDescriptor dependencyDescriptor = this.descriptorCache.get(internalOperationDescriptor.getId());
            if (dependencyDescriptor == null) continue;
            result.add(dependencyDescriptor);
        }
        return result;
    }

    private OperationDescriptor toDescriptor(InternalOperationDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultOperationDescriptor(descriptor, parent);
    }

    private synchronized @Nullable OperationDescriptor getParentDescriptor(@Nullable Object parentId) {
        if (parentId == null) {
            return null;
        }
        OperationDescriptor operationDescriptor = this.descriptorCache.get(parentId);
        if (operationDescriptor == null) {
            throw new IllegalStateException(String.format("Parent operation with id %s not available.", parentId));
        }
        return operationDescriptor;
    }

    private static @Nullable FileDownloadResult toFileDownloadResult(InternalOperationResult result) {
        InternalFileDownloadResult fileDownloadResult = (InternalFileDownloadResult)((Object)result);
        if (result instanceof InternalNotFoundFileDownloadResult) {
            return new NotFoundFileDownloadSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalSuccessResult) {
            return new DefaultFileDownloadSuccessResult(result.getStartTime(), result.getEndTime(), fileDownloadResult.getBytesDownloaded());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultFileDownloadFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()), fileDownloadResult.getBytesDownloaded());
        }
        return null;
    }

    private static @Nullable TestOperationResult toTestResult(InternalTestResult result) {
        if (result instanceof InternalTestSuccessResult) {
            return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestSkippedResult) {
            return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestFailureResult) {
            return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    public static @Nullable TaskOperationResult toTaskResult(InternalTaskResult result) {
        if (result instanceof InternalTaskSuccessResult) {
            InternalTaskSuccessResult successResult = (InternalTaskSuccessResult)result;
            if (result instanceof InternalJavaCompileTaskOperationResult) {
                List<JavaCompileTaskOperationResult.AnnotationProcessorResult> annotationProcessorResults = BuildProgressListenerAdapter.toAnnotationProcessorResults(((InternalJavaCompileTaskOperationResult)result).getAnnotationProcessorResults());
                return new DefaultJavaCompileTaskSuccessResult(result.getStartTime(), result.getEndTime(), successResult.isUpToDate(), BuildProgressListenerAdapter.isFromCache(result), BuildProgressListenerAdapter.toTaskExecutionDetails(result), annotationProcessorResults);
            }
            return new DefaultTaskSuccessResult(result.getStartTime(), result.getEndTime(), successResult.isUpToDate(), BuildProgressListenerAdapter.isFromCache(result), BuildProgressListenerAdapter.toTaskExecutionDetails(result));
        }
        if (result instanceof InternalTaskSkippedResult) {
            return new DefaultTaskSkippedResult(result.getStartTime(), result.getEndTime(), ((InternalTaskSkippedResult)result).getSkipMessage());
        }
        if (result instanceof InternalTaskFailureResult) {
            return new DefaultTaskFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()), BuildProgressListenerAdapter.toTaskExecutionDetails(result));
        }
        return null;
    }

    private static boolean isFromCache(InternalTaskResult result) {
        if (result instanceof InternalTaskCachedResult) {
            return ((InternalTaskCachedResult)result).isFromCache();
        }
        return false;
    }

    private static TaskExecutionDetails toTaskExecutionDetails(InternalTaskResult result) {
        if (result instanceof InternalIncrementalTaskResult) {
            InternalIncrementalTaskResult taskResult = (InternalIncrementalTaskResult)result;
            return TaskExecutionDetails.of(taskResult.isIncremental(), taskResult.getExecutionReasons());
        }
        return TaskExecutionDetails.unsupported();
    }

    private static @Nullable WorkItemOperationResult toWorkItemResult(InternalOperationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultWorkItemSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultWorkItemFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static @Nullable ProjectConfigurationOperationResult toProjectConfigurationResult(InternalProjectConfigurationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultProjectConfigurationSuccessResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toPluginApplicationResults(result.getPluginApplicationResults()));
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultProjectConfigurationFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()), BuildProgressListenerAdapter.toPluginApplicationResults(result.getPluginApplicationResults()));
        }
        return null;
    }

    private static List<? extends ProjectConfigurationOperationResult.PluginApplicationResult> toPluginApplicationResults(List<? extends InternalProjectConfigurationResult.InternalPluginApplicationResult> pluginApplicationResults) {
        ArrayList<DefaultPluginApplicationResult> results = new ArrayList<DefaultPluginApplicationResult>();
        for (InternalProjectConfigurationResult.InternalPluginApplicationResult internalPluginApplicationResult : pluginApplicationResults) {
            PluginIdentifier plugin = BuildProgressListenerAdapter.toPluginIdentifier(internalPluginApplicationResult.getPlugin());
            if (plugin == null) continue;
            results.add(new DefaultPluginApplicationResult(plugin, internalPluginApplicationResult.getTotalConfigurationTime()));
        }
        return results;
    }

    private static @Nullable PluginIdentifier toPluginIdentifier(InternalPluginIdentifier pluginIdentifier) {
        if (pluginIdentifier instanceof InternalBinaryPluginIdentifier) {
            InternalBinaryPluginIdentifier binaryPlugin = (InternalBinaryPluginIdentifier)pluginIdentifier;
            return new DefaultBinaryPluginIdentifier(binaryPlugin.getDisplayName(), binaryPlugin.getClassName(), binaryPlugin.getPluginId());
        }
        if (pluginIdentifier instanceof InternalScriptPluginIdentifier) {
            InternalScriptPluginIdentifier scriptPlugin = (InternalScriptPluginIdentifier)pluginIdentifier;
            return new DefaultScriptPluginIdentifier(scriptPlugin.getDisplayName(), scriptPlugin.getUri());
        }
        return null;
    }

    private static @Nullable TransformOperationResult toTransformResult(InternalOperationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultTransformSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultTransformFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static @Nullable OperationResult toResult(InternalOperationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultOperationSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultOperationFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    public static List<Failure> toFailures(@Nullable Collection<? extends InternalFailure> causes) {
        if (causes == null) {
            return null;
        }
        ArrayList<Failure> failures = new ArrayList<Failure>(causes.size());
        for (InternalFailure internalFailure : causes) {
            Failure f = BuildProgressListenerAdapter.toFailure(internalFailure);
            if (f == null) continue;
            failures.add(f);
        }
        return failures;
    }

    private static @Nullable Failure toFailure(InternalBasicProblemDetails problemDetails) {
        if (!(problemDetails instanceof InternalBasicProblemDetailsVersion2)) {
            return null;
        }
        return BuildProgressListenerAdapter.toFailure(((InternalBasicProblemDetailsVersion2)problemDetails).getFailure());
    }

    private static @Nullable Failure toFailure(InternalFailure origFailure) {
        if (origFailure == null) {
            return null;
        }
        ArrayList<InternalBasicProblemDetailsVersion3> problemDetails = new ArrayList<InternalBasicProblemDetailsVersion3>();
        try {
            problemDetails.addAll(origFailure.getProblems());
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        ArrayList<Problem> clientProblems = new ArrayList<Problem>(problemDetails.size());
        for (InternalBasicProblemDetailsVersion3 problemDetail : problemDetails) {
            if (problemDetail == null) continue;
            clientProblems.add(BuildProgressListenerAdapter.toProblem(problemDetail));
        }
        if (origFailure instanceof InternalTestAssertionFailure) {
            InternalTestAssertionFailure assertionFailure;
            if (origFailure instanceof InternalFileComparisonTestAssertionFailure) {
                assertionFailure = (InternalTestAssertionFailure)origFailure;
                return new DefaultFileComparisonTestAssertionFailure(assertionFailure.getMessage(), assertionFailure.getDescription(), assertionFailure.getExpected(), assertionFailure.getActual(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()), ((InternalTestAssertionFailure)origFailure).getClassName(), ((InternalTestAssertionFailure)origFailure).getStacktrace(), ((InternalFileComparisonTestAssertionFailure)origFailure).getExpectedContent(), ((InternalFileComparisonTestAssertionFailure)origFailure).getActualContent());
            }
            assertionFailure = (InternalTestAssertionFailure)origFailure;
            return new DefaultTestAssertionFailure(assertionFailure.getMessage(), assertionFailure.getDescription(), assertionFailure.getExpected(), assertionFailure.getActual(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()), ((InternalTestAssertionFailure)origFailure).getClassName(), ((InternalTestAssertionFailure)origFailure).getStacktrace());
        }
        if (origFailure instanceof InternalTestFrameworkFailure) {
            InternalTestFrameworkFailure frameworkFailure = (InternalTestFrameworkFailure)origFailure;
            return new DefaultTestFrameworkFailure(frameworkFailure.getMessage(), frameworkFailure.getDescription(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()), ((InternalTestFrameworkFailure)origFailure).getClassName(), ((InternalTestFrameworkFailure)origFailure).getStacktrace());
        }
        return new DefaultFailure(origFailure.getMessage(), origFailure.getDescription(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()), clientProblems);
    }

    private static @Nullable List<JavaCompileTaskOperationResult.AnnotationProcessorResult> toAnnotationProcessorResults(@Nullable List<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult> protocolResults) {
        if (protocolResults == null) {
            return null;
        }
        ArrayList<JavaCompileTaskOperationResult.AnnotationProcessorResult> results = new ArrayList<JavaCompileTaskOperationResult.AnnotationProcessorResult>();
        for (InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult result : protocolResults) {
            results.add(BuildProgressListenerAdapter.toAnnotationProcessorResult(result));
        }
        return results;
    }

    private static JavaCompileTaskOperationResult.AnnotationProcessorResult toAnnotationProcessorResult(InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult result) {
        return new DefaultAnnotationProcessorResult(result.getClassName(), BuildProgressListenerAdapter.toAnnotationProcessorResultType(result.getType()), result.getDuration());
    }

    private static JavaCompileTaskOperationResult.AnnotationProcessorResult.Type toAnnotationProcessorResultType(String type) {
        if (type.equals("AGGREGATING")) {
            return JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.AGGREGATING;
        }
        if (type.equals("ISOLATING")) {
            return JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.ISOLATING;
        }
        return JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.UNKNOWN;
    }
}

