/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.internal.FileUtils;
import org.gradle.internal.UncheckedException;

public class BasicFileResolver
implements Transformer<File, String> {
    private static final Pattern URI_SCHEME = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-\\.]*:.+");
    private final File baseDir;

    public BasicFileResolver(File baseDir) {
        this.baseDir = baseDir;
    }

    public File transform(String original) {
        if (original.startsWith("file:")) {
            try {
                return FileUtils.normalize((File)new File(new URI(original)));
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        File file = new File(original);
        if (file.isAbsolute()) {
            return FileUtils.normalize((File)file);
        }
        if (URI_SCHEME.matcher(original).matches()) {
            throw new InvalidUserDataException(String.format("Cannot convert URL '%s' to a file.", original));
        }
        file = new File(this.baseDir, original);
        return FileUtils.normalize((File)file);
    }
}

