/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.DecoratingTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestMetadataEvent;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.DefaultTestResult;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.TestState;
import org.gradle.api.internal.tasks.testing.results.UnknownTestDescriptor;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;

public class StateTrackingTestResultProcessor
implements TestResultProcessor {
    private final Map<Object, TestState> executing = new HashMap<Object, TestState>();
    private TestDescriptorInternal currentParent;
    private final TestListenerInternal listener;

    public StateTrackingTestResultProcessor(TestListenerInternal delegate) {
        this.listener = delegate;
    }

    public final void started(TestDescriptorInternal test, TestStartEvent event) {
        TestDescriptorInternal parent = null;
        if (event.getParentId() != null) {
            parent = this.executing.get((Object)event.getParentId()).test;
        }
        TestState state = new TestState(new DecoratingTestDescriptor(test, parent), event, this.executing);
        TestState oldState = this.executing.put(test.getId(), state);
        if (oldState != null) {
            throw new IllegalArgumentException(String.format("Received a start event for %s with duplicate id '%s'.", test, test.getId()));
        }
        this.listener.started(state.test, event);
    }

    private void ensureChildrenCompleted(Object testId, long endTime) {
        ArrayList<Object> incompleteChildren = new ArrayList<Object>();
        for (Map.Entry<Object, TestState> entry : this.executing.entrySet()) {
            if (!testId.equals(entry.getValue().startEvent.getParentId())) continue;
            incompleteChildren.add(entry.getKey());
        }
        if (!incompleteChildren.isEmpty()) {
            TestCompleteEvent skippedEvent = new TestCompleteEvent(endTime, TestResult.ResultType.SKIPPED);
            for (Object e : incompleteChildren) {
                this.completed(e, skippedEvent);
            }
        }
    }

    public final void completed(Object testId, TestCompleteEvent event) {
        this.ensureChildrenCompleted(testId, event.getEndTime());
        TestState testState = this.executing.remove(testId);
        if (testState == null) {
            throw new IllegalArgumentException(String.format("Received a completed event for test with unknown id '%s'. Registered test ids: '%s'", testId, this.executing.keySet()));
        }
        this.currentParent = testState.test.getParent();
        testState.completed(event);
        this.listener.completed(testState.test, new DefaultTestResult(testState), event);
    }

    public final void failure(Object testId, TestFailure testFailure) {
        TestState testState = this.executing.get(testId);
        if (testState == null) {
            throw new IllegalArgumentException(String.format("Received a failure event for test with unknown id '%s'. Registered test ids: '%s'", testId, this.executing.keySet()));
        }
        if (testFailure.getDetails().isAssumptionFailure()) {
            testState.assumptionFailure = testFailure;
        } else {
            testState.failures.add(testFailure);
        }
    }

    public final void output(Object testId, TestOutputEvent event) {
        this.listener.output(this.findDescriptor(testId), event);
    }

    private TestDescriptorInternal findDescriptor(Object testId) {
        TestState state = this.executing.get(testId);
        if (state != null) {
            return state.test;
        }
        if (this.currentParent != null) {
            return this.currentParent;
        }
        return new UnknownTestDescriptor();
    }

    public void published(Object testId, TestMetadataEvent keyValueEvent) {
        this.listener.metadata(this.findDescriptor(testId), keyValueEvent);
    }
}

