/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import org.gradle.api.Action;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Property;
import org.gradle.internal.Cast;
import org.gradle.internal.enterprise.impl.GradleEnterprisePluginAutoAppliedStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevelocityAutoAppliedPluginConfigurationAction
implements Action<AppliedPlugin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevelocityAutoAppliedPluginConfigurationAction.class);
    private final SettingsInternal settings;

    public DevelocityAutoAppliedPluginConfigurationAction(Settings settings) {
        this.settings = (SettingsInternal)settings;
    }

    public void execute(AppliedPlugin plugin) {
        GradleEnterprisePluginAutoAppliedStatus autoAppliedStatus = (GradleEnterprisePluginAutoAppliedStatus)this.settings.getServices().get(GradleEnterprisePluginAutoAppliedStatus.class);
        String develocityUrl = ((StartParameterInternal)this.settings.getStartParameter()).getDevelocityUrl();
        if (autoAppliedStatus.isAutoApplied() && develocityUrl != null) {
            Object develocityConfiguration = this.settings.getExtensions().getByName("develocity");
            try {
                Property server = (Property)Cast.uncheckedNonnullCast((Object)develocityConfiguration.getClass().getMethod("getServer", new Class[0]).invoke(develocityConfiguration, new Object[0]));
                server.convention((Object)develocityUrl);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unable to configure auto-applied Develocity plugin server URL", (Throwable)e);
                }
                LOGGER.warn("Unable to configure auto-applied Develocity plugin server URL");
            }
        }
    }
}

