/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.FileUtils;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instrumentation.agent.AgentStatus;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.LoggingOutputInternal;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DefaultDaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.DaemonMessageSerializer;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonLogFile;
import org.gradle.launcher.daemon.server.DaemonTcpServerConnector;
import org.gradle.launcher.daemon.server.MasterExpirationStrategy;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.HandleInvalidateVirtualFileSystem;
import org.gradle.launcher.daemon.server.api.HandleReportStatus;
import org.gradle.launcher.daemon.server.api.HandleStop;
import org.gradle.launcher.daemon.server.exec.CleanUpVirtualFileSystemAfterBuild;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;
import org.gradle.launcher.daemon.server.exec.EstablishBuildEnvironment;
import org.gradle.launcher.daemon.server.exec.ExecuteBuild;
import org.gradle.launcher.daemon.server.exec.ForwardClientInput;
import org.gradle.launcher.daemon.server.exec.HandleCancel;
import org.gradle.launcher.daemon.server.exec.LogAndCheckHealth;
import org.gradle.launcher.daemon.server.exec.LogToClient;
import org.gradle.launcher.daemon.server.exec.RequestStopIfSingleUsedDaemon;
import org.gradle.launcher.daemon.server.exec.ResetDeprecationLogger;
import org.gradle.launcher.daemon.server.exec.ReturnResult;
import org.gradle.launcher.daemon.server.exec.StartBuildOrRespondWithBusy;
import org.gradle.launcher.daemon.server.exec.WatchForDisconnection;
import org.gradle.launcher.daemon.server.health.DaemonHealthCheck;
import org.gradle.launcher.daemon.server.health.DaemonHealthStats;
import org.gradle.launcher.daemon.server.health.HealthExpirationStrategy;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.launcher.daemon.server.scaninfo.DaemonScanInfo;
import org.gradle.launcher.daemon.server.scaninfo.DefaultDaemonScanInfo;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecutor;
import org.gradle.tooling.internal.provider.action.BuildActionSerializer;

public class DaemonServices
implements ServiceRegistrationProvider {
    private final DaemonServerConfiguration configuration;
    private final LoggingManagerInternal loggingManager;
    private static final Logger LOGGER = Logging.getLogger(DaemonServices.class);

    public DaemonServices(DaemonServerConfiguration configuration, LoggingManagerInternal loggingManager) {
        this.configuration = configuration;
        this.loggingManager = loggingManager;
    }

    @Provides
    protected DaemonContext createDaemonContext(AgentStatus agentStatus, ProcessEnvironment processEnvironment) {
        LOGGER.debug("Creating daemon context with opts: {}", this.configuration.getJvmOptions());
        return new DefaultDaemonContext(this.configuration.getUid(), FileUtils.canonicalize((File)Jvm.current().getJavaHome()), JavaLanguageVersion.current(), Jvm.current().getVendor(), this.configuration.getBaseDir(), processEnvironment.maybeGetPid(), Integer.valueOf(this.configuration.getIdleTimeout()), this.configuration.getJvmOptions(), agentStatus.isAgentInstrumentationEnabled(), this.configuration.getNativeServicesMode(), this.configuration.getPriority());
    }

    @Provides
    protected DaemonLogFile createDaemonLogFile(DaemonContext daemonContext, DaemonDir daemonDir) {
        Long pid = daemonContext.getPid();
        return new DaemonLogFile(new File(daemonDir.getVersionedDir(), DaemonLogFile.getDaemonLogFileName(pid)));
    }

    @Provides
    protected DaemonHealthCheck createDaemonHealthCheck(ListenerManager listenerManager, HealthExpirationStrategy healthExpirationStrategy) {
        return new DaemonHealthCheck(healthExpirationStrategy, listenerManager);
    }

    @Provides
    protected DaemonRunningStats createDaemonRunningStats() {
        return new DaemonRunningStats();
    }

    @Provides
    protected DaemonScanInfo createDaemonScanInfo(DaemonRunningStats runningStats, ListenerManager listenerManager, DaemonRegistry daemonRegistry) {
        return new DefaultDaemonScanInfo(runningStats, this.configuration.getIdleTimeout(), this.configuration.isSingleUse(), daemonRegistry, listenerManager);
    }

    @Provides
    protected MasterExpirationStrategy createMasterExpirationStrategy(Daemon daemon, HealthExpirationStrategy healthExpirationStrategy, FileLockContentionHandler fileLockContentionHandler, ListenerManager listenerManager) {
        return new MasterExpirationStrategy(daemon, this.configuration, healthExpirationStrategy, fileLockContentionHandler, listenerManager);
    }

    @Provides
    protected HealthExpirationStrategy createHealthExpirationStrategy(DaemonHealthStats stats, GarbageCollectorMonitoringStrategy strategy) {
        return new HealthExpirationStrategy(stats, strategy);
    }

    @Provides
    protected DaemonHealthStats createDaemonHealthStats(DaemonRunningStats runningStats, GarbageCollectorMonitoringStrategy strategy, ExecutorFactory executorFactory) {
        return new DaemonHealthStats(runningStats, strategy, executorFactory);
    }

    @Provides
    protected GarbageCollectorMonitoringStrategy createGarbageCollectorMonitoringStrategy() {
        return GarbageCollectorMonitoringStrategy.determineGcStrategy();
    }

    @Provides
    protected ImmutableList<DaemonCommandAction> createDaemonCommandActions(BuildExecutor buildActionExecuter, DaemonContext daemonContext, DaemonHealthCheck healthCheck, DaemonHealthStats healthStats, DaemonRunningStats runningStats, ExecutorFactory executorFactory, ProcessEnvironment processEnvironment, UserInputReader inputReader, OutputEventListener eventDispatch, DaemonLogFile daemonLogFile, GradleUserHomeScopeServiceRegistry userHomeServiceRegistry, ListenerManager listenerManager) {
        DaemonDiagnostics daemonDiagnostics = new DaemonDiagnostics(daemonLogFile.getFile(), daemonContext.getPid());
        return ImmutableList.of((Object)new HandleStop(listenerManager), (Object)new HandleInvalidateVirtualFileSystem(userHomeServiceRegistry), (Object)new HandleCancel(), (Object)new HandleReportStatus(), (Object)new CleanUpVirtualFileSystemAfterBuild(executorFactory, userHomeServiceRegistry), (Object)new ReturnResult(), (Object)new StartBuildOrRespondWithBusy(daemonDiagnostics), (Object)new EstablishBuildEnvironment(processEnvironment), (Object)new LogToClient((LoggingOutputInternal)this.loggingManager, daemonDiagnostics), (Object)new LogAndCheckHealth(healthStats, healthCheck, runningStats), (Object)new ForwardClientInput(inputReader, eventDispatch), (Object)new RequestStopIfSingleUsedDaemon(), (Object[])new DaemonCommandAction[]{new ResetDeprecationLogger(), new WatchForDisconnection(), new ExecuteBuild((BuildActionExecutor<BuildActionParameters, BuildRequestContext>)buildActionExecuter, runningStats)});
    }

    @Provides
    Serializer<BuildAction> createBuildActionSerializer() {
        return BuildActionSerializer.create();
    }

    @Provides
    protected Daemon createDaemon(ImmutableList<DaemonCommandAction> actions, Serializer<BuildAction> buildActionSerializer, ExecutorFactory executorFactory, InetAddressFactory inetAddressFactory, DaemonRegistry daemonRegistry, DaemonContext daemonContext, ListenerManager listenerManager) {
        return new Daemon(new DaemonTcpServerConnector(executorFactory, inetAddressFactory, (Serializer<Message>)DaemonMessageSerializer.create(buildActionSerializer)), daemonRegistry, daemonContext, new DaemonCommandExecuter(this.configuration, actions), executorFactory, listenerManager);
    }
}

