/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Objects;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;
import org.jspecify.annotations.Nullable;

public class UsageCompatibilityHandler {
    private final IsolatableFactory isolatableFactory;
    private final NamedObjectInstantiator instantiator;

    UsageCompatibilityHandler(IsolatableFactory isolatableFactory, NamedObjectInstantiator instantiator) {
        this.isolatableFactory = isolatableFactory;
        this.instantiator = instantiator;
    }

    @Deprecated
    public <T> ImmutableAttributes doConcat(AttributesFactory factory, ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        assert (key.getName().equals(Usage.USAGE_ATTRIBUTE.getName())) : "Should only be invoked for 'org.gradle.usage', got '" + key.getName() + "'";
        if (value instanceof CoercingStringValueSnapshot) {
            String val = (String)((CoercingStringValueSnapshot)value).getValue();
            String replacementUsage = UsageCompatibilityHandler.getReplacementUsage(val);
            String libraryElements = UsageCompatibilityHandler.getLibraryElements(val);
            if (replacementUsage == null || libraryElements == null) {
                return factory.concat(node, key, value);
            }
            Attribute<String> typedAttribute = UsageCompatibilityHandler.getAs(key, String.class);
            CoercingStringValueSnapshot coercingStringValueSnapshot = new CoercingStringValueSnapshot(replacementUsage, this.instantiator);
            ImmutableAttributes usageNode = factory.concat(node, typedAttribute, coercingStringValueSnapshot);
            return factory.concat(usageNode, Attribute.of((String)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.getName(), String.class), new CoercingStringValueSnapshot(libraryElements, this.instantiator));
        }
        String val = Objects.requireNonNull(value.isolate()).toString();
        String replacementUsage = UsageCompatibilityHandler.getReplacementUsage(val);
        String libraryElements = UsageCompatibilityHandler.getLibraryElements(val);
        if (replacementUsage == null || libraryElements == null) {
            return factory.concat(node, key, value);
        }
        Attribute<Usage> typedAttribute = UsageCompatibilityHandler.getAs(key, Usage.class);
        Isolatable isolate = this.isolatableFactory.isolate((Object)((Usage)this.instantiator.named(Usage.class, replacementUsage)));
        ImmutableAttributes usageNode = factory.concat(node, typedAttribute, isolate);
        return factory.concat(usageNode, LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.isolatableFactory.isolate((Object)((LibraryElements)this.instantiator.named(LibraryElements.class, libraryElements))));
    }

    private static <T> Attribute<T> getAs(Attribute<?> key, Class<T> type) {
        assert (key.getType() == type) : "Attribute type must be a " + type;
        return key;
    }

    public static @Nullable String getReplacementUsage(String usage) {
        if (usage.endsWith("-jars")) {
            return usage.substring(0, usage.length() - "-jars".length());
        }
        if (usage.endsWith("-classes")) {
            return usage.substring(0, usage.length() - "-classes".length());
        }
        if (usage.endsWith("-resources")) {
            return usage.substring(0, usage.length() - "-resources".length());
        }
        return null;
    }

    public static @Nullable String getLibraryElements(String usage) {
        if (usage.endsWith("-jars")) {
            return "jar";
        }
        if (usage.endsWith("-classes")) {
            return "classes";
        }
        if (usage.endsWith("-resources")) {
            return "resources";
        }
        return null;
    }
}

