/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.NamedDomainObjectCollectionSchema;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.BindsProjectFeature;
import org.gradle.api.internal.plugins.BindsProjectType;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.Definition;
import org.gradle.api.internal.plugins.ProjectFeatureApplyAction;
import org.gradle.api.internal.plugins.ProjectFeatureBinding;
import org.gradle.api.internal.plugins.ProjectFeatureBindingBuilder;
import org.gradle.api.internal.plugins.ProjectFeatureBindingDeclaration;
import org.gradle.api.internal.plugins.ProjectTypeBinding;
import org.gradle.api.internal.plugins.ProjectTypeBindingBuilder;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Cast;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.plugin.software.internal.DefaultProjectFeatureBindingBuilder;
import org.gradle.plugin.software.internal.DefaultProjectFeatureImplementation;
import org.gradle.plugin.software.internal.DefaultProjectTypeBindingBuilder;
import org.gradle.plugin.software.internal.ProjectFeatureDeclarations;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.jspecify.annotations.Nullable;

public class DefaultProjectFeatureDeclarations
implements ProjectFeatureDeclarations {
    private final Map<RegisteringPluginKey, Set<Class<? extends Plugin<Project>>>> pluginClasses = new LinkedHashMap<RegisteringPluginKey, Set<Class<? extends Plugin<Project>>>>();
    private final Map<String, Class<? extends Plugin<Project>>> registeredTypes = new HashMap<String, Class<? extends Plugin<Project>>>();
    private @Nullable Map<String, ProjectFeatureImplementation<?, ?>> projectFeatureImplementations;
    private final InspectionScheme inspectionScheme;
    private final Instantiator instantiator;

    public DefaultProjectFeatureDeclarations(InspectionScheme inspectionScheme, Instantiator instantiator) {
        this.inspectionScheme = inspectionScheme;
        this.instantiator = instantiator;
    }

    public void addDeclaration(@Nullable String pluginId, Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass) {
        if (this.projectFeatureImplementations != null) {
            throw new IllegalStateException("Cannot register a plugin after project types have been discovered");
        }
        RegisteringPluginKey pluginKey = new RegisteringPluginKey(registeringPluginClass, pluginId);
        this.pluginClasses.computeIfAbsent(pluginKey, k -> new LinkedHashSet()).add(pluginClass);
    }

    private Map<String, ProjectFeatureImplementation<?, ?>> discoverProjectFeatureImplementations() {
        ImmutableMap.Builder projectFeatureImplementationsBuilder = ImmutableMap.builder();
        this.pluginClasses.forEach((registeringPluginClass, registeredPluginClasses) -> registeredPluginClasses.forEach(pluginClass -> {
            TypeMetadata pluginClassTypeMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(pluginClass);
            TypeAnnotationMetadata pluginClassAnnotationMetadata = pluginClassTypeMetadata.getTypeAnnotationMetadata();
            this.registerTypeIfPresent((RegisteringPluginKey)registeringPluginClass, (Class<? extends Plugin<Project>>)pluginClass, pluginClassAnnotationMetadata, (ImmutableMap.Builder<String, ProjectFeatureImplementation<?, ?>>)projectFeatureImplementationsBuilder);
            this.registerFeaturesIfPresent((RegisteringPluginKey)registeringPluginClass, (Class<? extends Plugin<Project>>)pluginClass, pluginClassAnnotationMetadata, (ImmutableMap.Builder<String, ProjectFeatureImplementation<?, ?>>)projectFeatureImplementationsBuilder);
        }));
        return projectFeatureImplementationsBuilder.build();
    }

    private <T extends Definition<V>, V extends BuildModel> void registerFeature(RegisteringPluginKey registeringPlugin, Class<? extends Plugin<Project>> pluginClass, ProjectFeatureBindingDeclaration<T, V> binding, ImmutableMap.Builder<String, ProjectFeatureImplementation<?, ?>> projectFeatureImplementationsBuilder) {
        String projectFeatureName = binding.getName();
        Class<? extends Plugin<Project>> existingPluginClass = this.registeredTypes.put(projectFeatureName, pluginClass);
        if (existingPluginClass != null && existingPluginClass != pluginClass) {
            throw new IllegalArgumentException("Project feature '" + projectFeatureName + "' is registered by both '" + pluginClass.getName() + "' and '" + existingPluginClass.getName() + "'");
        }
        projectFeatureImplementationsBuilder.put((Object)projectFeatureName, new DefaultProjectFeatureImplementation(projectFeatureName, binding.getDefinitionType(), binding.getDefinitionImplementationType().orElse(binding.getDefinitionType()), binding.targetDefinitionType(), binding.getBuildModelType(), binding.getBuildModelImplementationType().orElse(binding.getBuildModelType()), pluginClass, registeringPlugin.pluginClass, registeringPlugin.pluginId, (ProjectFeatureApplyAction)Cast.uncheckedCast((Object)binding.getTransform())));
    }

    private void registerFeaturesIfPresent(RegisteringPluginKey registeringPluginClass, Class<? extends Plugin<Project>> pluginClass, TypeAnnotationMetadata pluginClassAnnotationMetadata, ImmutableMap.Builder<String, ProjectFeatureImplementation<?, ?>> projectFeatureImplementationsBuilder) {
        Optional bindsProjectFeatureAnnotation = pluginClassAnnotationMetadata.getAnnotation(BindsProjectFeature.class);
        if (bindsProjectFeatureAnnotation.isPresent()) {
            BindsProjectFeature bindsSoftwareType = (BindsProjectFeature)bindsProjectFeatureAnnotation.get();
            Class bindingRegistrationClass = bindsSoftwareType.value();
            ProjectFeatureBinding bindingRegistration = (ProjectFeatureBinding)this.instantiator.newInstance(bindingRegistrationClass, new Object[0]);
            DefaultProjectFeatureBindingBuilder builder = new DefaultProjectFeatureBindingBuilder();
            bindingRegistration.bind((ProjectFeatureBindingBuilder)builder);
            builder.build().forEach(binding -> this.registerFeature(registeringPluginClass, pluginClass, (ProjectFeatureBindingDeclaration)binding, projectFeatureImplementationsBuilder));
        }
    }

    private void registerTypeIfPresent(RegisteringPluginKey registeringPluginKey, Class<? extends Plugin<Project>> pluginClass, TypeAnnotationMetadata pluginClassAnnotationMetadata, ImmutableMap.Builder<String, ProjectFeatureImplementation<?, ?>> projectFeatureImplementationsBuilder) {
        Optional bindsProjectTypeAnnotation = pluginClassAnnotationMetadata.getAnnotation(BindsProjectType.class);
        if (bindsProjectTypeAnnotation.isPresent()) {
            BindsProjectType bindsProjectType = (BindsProjectType)bindsProjectTypeAnnotation.get();
            Class bindingRegistrationClass = bindsProjectType.value();
            ProjectTypeBinding bindingRegistration = (ProjectTypeBinding)this.instantiator.newInstance(bindingRegistrationClass, new Object[0]);
            DefaultProjectTypeBindingBuilder builder = new DefaultProjectTypeBindingBuilder();
            bindingRegistration.bind((ProjectTypeBindingBuilder)builder);
            builder.build().forEach(binding -> this.registerFeature(registeringPluginKey, pluginClass, (ProjectFeatureBindingDeclaration)binding, projectFeatureImplementationsBuilder));
        }
    }

    public Map<String, ProjectFeatureImplementation<?, ?>> getProjectFeatureImplementations() {
        if (this.projectFeatureImplementations == null) {
            this.projectFeatureImplementations = this.discoverProjectFeatureImplementations();
        }
        return this.projectFeatureImplementations;
    }

    public NamedDomainObjectCollectionSchema getSchema() {
        return () -> Iterables.transform(() -> this.getProjectFeatureImplementations().entrySet().iterator(), entry -> new ProjectFeatureSchema((String)entry.getKey(), ((ProjectFeatureImplementation)entry.getValue()).getDefinitionPublicType()));
    }

    public static class RegisteringPluginKey {
        public final Class<? extends Plugin<Settings>> pluginClass;
        public final @Nullable String pluginId;

        public RegisteringPluginKey(Class<? extends Plugin<Settings>> pluginClass, @Nullable String pluginId) {
            this.pluginClass = pluginClass;
            this.pluginId = pluginId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegisteringPluginKey)) {
                return false;
            }
            RegisteringPluginKey pluginKey = (RegisteringPluginKey)o;
            return Objects.equals(this.pluginClass, pluginKey.pluginClass) && Objects.equals(this.pluginId, pluginKey.pluginId);
        }

        public int hashCode() {
            return Objects.hash(this.pluginClass, this.pluginId);
        }
    }

    private static class ProjectFeatureSchema
    implements NamedDomainObjectCollectionSchema.NamedDomainObjectSchema {
        private final String name;
        private final Class<?> modelPublicType;

        public ProjectFeatureSchema(String name, Class<?> modelPublicType) {
            this.name = name;
            this.modelPublicType = modelPublicType;
        }

        public String getName() {
            return this.name;
        }

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(this.modelPublicType);
        }
    }
}

