/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import java.util.ArrayList;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class SerializedPayloadSerializer
implements Serializer<SerializedPayload> {
    private final Serializer<Object> javaSerializer = new DefaultSerializer<Object>();

    @Override
    public void write(Encoder encoder, SerializedPayload value) throws Exception {
        this.javaSerializer.write(encoder, value.getHeader());
        encoder.writeSmallInt(value.getSerializedModel().size());
        for (byte[] bytes : value.getSerializedModel()) {
            encoder.writeBinary(bytes);
        }
    }

    @Override
    public SerializedPayload read(Decoder decoder) throws Exception {
        Object header = this.javaSerializer.read(decoder);
        int count = decoder.readSmallInt();
        ArrayList<byte[]> chunks = new ArrayList<byte[]>(count);
        for (int i = 0; i < count; ++i) {
            chunks.add(decoder.readBinary());
        }
        return new SerializedPayload(header, chunks);
    }
}

