/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.MultiCauseException;

public final class ExceptionSerializationUtil {
    public static final Set<String> CANDIDATE_GET_CAUSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("getCauses", "getFailures")));

    private ExceptionSerializationUtil() {
    }

    public static List<? extends Throwable> extractCauses(Throwable throwable) {
        Throwable causeTmp;
        if (throwable instanceof MultiCauseException) {
            return ((MultiCauseException)throwable).getCauses();
        }
        List<? extends Throwable> causes = ExceptionSerializationUtil.tryExtractMultiCauses(throwable);
        if (causes != null) {
            return causes;
        }
        try {
            causeTmp = throwable.getCause();
        }
        catch (Throwable ignored) {
            causeTmp = null;
        }
        return causeTmp == null ? Collections.emptyList() : Collections.singletonList(causeTmp);
    }

    private static List<? extends Throwable> tryExtractMultiCauses(Throwable throwable) {
        Method causesMethod = ExceptionSerializationUtil.findCandidateGetCausesMethod(throwable);
        if (causesMethod != null) {
            Collection causes;
            try {
                causes = (Collection)Cast.uncheckedCast((Object)causesMethod.invoke((Object)throwable, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return null;
            }
            if (causes == null || causes.isEmpty()) {
                return null;
            }
            for (Object cause : causes) {
                if (cause instanceof Throwable) continue;
                return null;
            }
            ArrayList<Throwable> result = new ArrayList<Throwable>(causes.size());
            for (Object cause : causes) {
                result.add((Throwable)Cast.uncheckedCast(cause));
            }
            return result;
        }
        return null;
    }

    private static Method findCandidateGetCausesMethod(Throwable throwable) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = throwable.getClass().getDeclaredMethods()) {
            Class<?> returnType;
            if (!CANDIDATE_GET_CAUSES.contains(method.getName()) || !Collection.class.isAssignableFrom(returnType = method.getReturnType())) continue;
            return method;
        }
        return null;
    }
}

