/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.io.IOException;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.HtmlWriterTools;
import org.gradle.reporting.ReportRenderer;
import org.jspecify.annotations.NullMarked;

public class CodePanelRenderer
extends ReportRenderer<Data, SimpleHtmlWriter> {
    @Override
    public void render(Data data, SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("span").attribute("class", "code").startElement("pre").attribute("id", data.codePanelId).characters((CharSequence)data.text).endElement();
        HtmlWriterTools.addClipboardCopyButton(htmlWriter, data.codePanelId);
        htmlWriter.endElement();
    }

    @NullMarked
    public static final class Data {
        private final String text;
        private final String codePanelId;

        public Data(String text, String codePanelId) {
            this.text = text;
            this.codePanelId = codePanelId;
        }
    }
}

