/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.Definition;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.ProjectFeatureApplicationContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Cast;
import org.gradle.plugin.software.internal.ModelDefaultsApplicator;
import org.gradle.plugin.software.internal.ProjectFeatureApplicationContextInternal;
import org.gradle.plugin.software.internal.ProjectFeatureApplicator;
import org.gradle.plugin.software.internal.ProjectFeatureDeclarations;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.gradle.plugin.software.internal.ProjectFeatureSupportInternal;

public class DefaultProjectFeatureApplicator
implements ProjectFeatureApplicator {
    private final ProjectFeatureDeclarations projectFeatureDeclarations;
    private final ModelDefaultsApplicator modelDefaultsApplicator;
    private final PluginManagerInternal pluginManager;
    private final ClassLoaderScope classLoaderScope;
    private final ObjectFactory objectFactory;

    public DefaultProjectFeatureApplicator(ProjectFeatureDeclarations projectFeatureDeclarations, ModelDefaultsApplicator modelDefaultsApplicator, PluginManagerInternal pluginManager, ClassLoaderScope classLoaderScope, ObjectFactory objectFactory) {
        this.projectFeatureDeclarations = projectFeatureDeclarations;
        this.modelDefaultsApplicator = modelDefaultsApplicator;
        this.pluginManager = pluginManager;
        this.classLoaderScope = classLoaderScope;
        this.objectFactory = objectFactory;
    }

    public <T extends Definition<V>, V extends BuildModel> T applyFeatureTo(DynamicObjectAware parentDefinition, ProjectFeatureImplementation<T, V> projectFeature) {
        ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext parentDefinitionContext = ProjectFeatureSupportInternal.getContext((DynamicObjectAware)parentDefinition);
        ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext.ChildDefinitionAdditionResult result = parentDefinitionContext.getOrAddChildDefinition(projectFeature, () -> {
            if (parentDefinition instanceof Project) {
                DefaultProjectFeatureApplicator.checkSingleProjectTypeApplication(parentDefinitionContext, projectFeature);
            }
            this.pluginManager.apply(projectFeature.getPluginClass());
            Object definition = this.instantiateBoundFeatureObjectsAndApply(parentDefinition, projectFeature);
            return Cast.uncheckedNonnullCast(definition);
        });
        if (result.isNew) {
            Plugin plugin = this.pluginManager.getPluginContainer().getPlugin(projectFeature.getPluginClass());
            this.modelDefaultsApplicator.applyDefaultsTo((Object)parentDefinition, result.definition, (ModelDefaultsApplicator.ClassLoaderContext)new ClassLoaderContextFromScope(this.classLoaderScope), plugin, projectFeature);
        }
        return (T)((Definition)Cast.uncheckedNonnullCast((Object)result.definition));
    }

    private static <T extends Definition<V>, V extends BuildModel> void checkSingleProjectTypeApplication(ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext context, ProjectFeatureImplementation<T, V> projectFeature) {
        context.childrenDefinitions().keySet().stream().findFirst().ifPresent(projectTypeAlreadyApplied -> {
            throw new IllegalStateException("The project has already applied the '" + projectTypeAlreadyApplied.getFeatureName() + "' project type and is also attempting to apply the '" + projectFeature.getFeatureName() + "' project type.  Only one project type can be applied to a project.");
        });
    }

    private <T extends Definition<V>, V extends BuildModel> T instantiateBoundFeatureObjectsAndApply(Object parentDefinition, ProjectFeatureImplementation<T, V> projectFeature) {
        T definition = this.instantiateDefinitionObject(parentDefinition, projectFeature);
        BuildModel buildModelInstance = ProjectFeatureSupportInternal.createBuildModelInstance((ObjectFactory)this.objectFactory, definition, projectFeature);
        ProjectFeatureSupportInternal.attachDefinitionContext(definition, (BuildModel)buildModelInstance, (ProjectFeatureApplicator)this, (ProjectFeatureDeclarations)this.projectFeatureDeclarations, (ObjectFactory)this.objectFactory);
        ProjectFeatureApplicationContext applyActionContext = (ProjectFeatureApplicationContext)this.objectFactory.newInstance(ProjectFeatureApplicationContextInternal.class, new Object[0]);
        projectFeature.getBindingTransform().transform(applyActionContext, definition, (Object)buildModelInstance, Cast.uncheckedCast((Object)parentDefinition));
        return definition;
    }

    private <T extends Definition<V>, V extends BuildModel> T instantiateDefinitionObject(Object target, ProjectFeatureImplementation<T, V> projectFeature) {
        Class dslType = projectFeature.getDefinitionImplementationType();
        if (Named.class.isAssignableFrom(dslType)) {
            if (target instanceof Named) {
                return (T)((Definition)this.objectFactory.newInstance(projectFeature.getDefinitionPublicType(), new Object[]{((Named)target).getName()}));
            }
            throw new IllegalArgumentException("Cannot infer a name for definition " + dslType.getSimpleName() + " because the parent definition of type " + target.getClass().getSimpleName() + " does not implement Named.");
        }
        return (T)((Definition)this.objectFactory.newInstance(dslType, new Object[0]));
    }

    private static class ClassLoaderContextFromScope
    implements ModelDefaultsApplicator.ClassLoaderContext {
        private final ClassLoaderScope scope;

        public ClassLoaderContextFromScope(ClassLoaderScope scope) {
            this.scope = scope;
        }

        public ClassLoader getClassLoader() {
            return this.scope.getLocalClassLoader();
        }

        public ClassLoader getParentClassLoader() {
            return this.scope.getParent().getLocalClassLoader();
        }
    }
}

