/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.initialization.ProjectSpec;

public abstract class AbstractProjectSpec
implements ProjectSpec {
    private static final String UNRELATED_BUILD_HINT = " If this is an unrelated build, it must have its own settings file.";

    @Override
    public boolean containsProject(ProjectDescriptorRegistry registry) {
        this.checkPreconditions(registry);
        ArrayList<ProjectDescriptorInternal> matches = new ArrayList<ProjectDescriptorInternal>();
        this.select(registry, matches);
        return !matches.isEmpty();
    }

    @Override
    public ProjectDescriptorInternal selectProject(String settingsDescription, ProjectDescriptorRegistry registry) {
        this.checkPreconditions(registry);
        ArrayList<ProjectDescriptorInternal> matches = new ArrayList<ProjectDescriptorInternal>();
        this.select(registry, matches);
        if (matches.isEmpty()) {
            String message = this.formatNoMatchesMessage(settingsDescription) + UNRELATED_BUILD_HINT;
            throw new InvalidUserDataException(message);
        }
        if (matches.size() != 1) {
            throw new InvalidUserDataException(this.formatMultipleMatchesMessage(matches));
        }
        return (ProjectDescriptorInternal)matches.get(0);
    }

    protected void checkPreconditions(ProjectDescriptorRegistry registry) {
    }

    protected abstract String formatMultipleMatchesMessage(Iterable<ProjectDescriptorInternal> var1);

    protected abstract String formatNoMatchesMessage(String var1);

    protected abstract void select(ProjectDescriptorRegistry var1, List<ProjectDescriptorInternal> var2);
}

