/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.CrossProjectModelAccess;
import org.gradle.api.internal.project.LifecycleAwareProject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskDependencyUsageTracker;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.invocation.GradleLifecycleActionExecutor;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class DefaultCrossProjectModelAccess
implements CrossProjectModelAccess {
    private final ProjectRegistry projectRegistry;
    private final Instantiator instantiator;
    private final GradleLifecycleActionExecutor gradleLifecycleActionExecutor;

    public DefaultCrossProjectModelAccess(ProjectRegistry projectRegistry, Instantiator instantiator, GradleLifecycleActionExecutor gradleLifecycleActionExecutor) {
        this.projectRegistry = projectRegistry;
        this.instantiator = instantiator;
        this.gradleLifecycleActionExecutor = gradleLifecycleActionExecutor;
    }

    @Override
    public ProjectInternal access(ProjectInternal referrer, ProjectInternal project) {
        return LifecycleAwareProject.wrap(project, referrer, this.instantiator, this.gradleLifecycleActionExecutor);
    }

    @Override
    public @Nullable ProjectInternal findProject(ProjectInternal referrer, Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Project path must be absolute");
        }
        ProjectInternal project = this.projectRegistry.getProjectInternal(path.asString());
        return project != null ? LifecycleAwareProject.wrap(project, referrer, this.instantiator, this.gradleLifecycleActionExecutor) : null;
    }

    @Override
    public Map<String, Project> getChildProjects(ProjectInternal referrer, ProjectInternal target) {
        return target.getOwner().getChildProjects().stream().collect(Collectors.toMap(ProjectState::getName, projectState -> LifecycleAwareProject.wrap(projectState.getMutableModel(), referrer, this.instantiator, this.gradleLifecycleActionExecutor)));
    }

    @Override
    public Set<? extends ProjectInternal> getSubprojects(ProjectInternal referrer, ProjectInternal target) {
        return this.projectRegistry.getSubProjects(target.getPath()).stream().map(project -> LifecycleAwareProject.wrap(project, referrer, this.instantiator, this.gradleLifecycleActionExecutor)).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Set<? extends ProjectInternal> getAllprojects(ProjectInternal referrer, ProjectInternal target) {
        return this.projectRegistry.getAllProjects(target.getPath()).stream().map(project -> LifecycleAwareProject.wrap(project, referrer, this.instantiator, this.gradleLifecycleActionExecutor)).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public GradleInternal gradleInstanceForProject(ProjectInternal referrerProject, GradleInternal gradle) {
        return gradle;
    }

    @Override
    public @Nullable TaskDependencyUsageTracker taskDependencyUsageTracker(ProjectInternal referrerProject) {
        return null;
    }

    @Override
    public TaskExecutionGraphInternal taskGraphForProject(ProjectInternal referrerProject, TaskExecutionGraphInternal taskGraph) {
        return taskGraph;
    }

    @Override
    public @Nullable DynamicObject parentProjectDynamicInheritedScope(ProjectInternal referrerProject) {
        ProjectInternal parent = referrerProject.getParent();
        return parent != null ? parent.getInheritedScope() : null;
    }
}

