/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.plugin.management;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.internal.HasInternalProtocol;
import org.gradle.plugin.use.PluginId;
import org.jspecify.annotations.Nullable;

/**
 * Contains information about a plugin that has been requested for resolution.
 *
 * @since 3.5
 */
@HasInternalProtocol
public interface PluginRequest {

    /**
     * The ID of the plugin requested. Never null.
     */
    PluginId getId();

    /**
     * The version of the plugin if one was specified, otherwise null.
     */
    @Nullable
    String getVersion();

    /**
     * The implementation module of the plugin if one was explicitly specified, otherwise null.
     * <p>
     * Prefer {@link #getSelector()}.
     */
    @Nullable
    ModuleVersionSelector getModule();

    /**
     * A selector for the implementation of the plugin if one was explicitly specified, otherwise null.
     *
     * @since 9.2.0
     */
    @Nullable ComponentSelector getSelector();

}
