/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.StartParameter;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ProblemsProgressEventEmitterHolder;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildTreeLifecycleListener;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.work.ProjectParallelExecutionController;
import org.gradle.problems.buildtree.ProblemStream;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.VersionNumber;

@ServiceScope(value={Scope.BuildTree.class})
public class RootBuildLifecycleBuildActionExecutor {
    private final BuildModelParameters buildModelParameters;
    private final ProjectParallelExecutionController projectParallelExecutionController;
    private final BuildTreeLifecycleListener lifecycleListener;
    private final InternalProblems problemsService;
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final StartParameter startParameter;
    private final ProblemStream problemsStream;
    private final BuildActionRunner buildActionRunner;
    private final BuildStateRegistry buildStateRegistry;
    private boolean executed;

    public RootBuildLifecycleBuildActionExecutor(BuildModelParameters buildModelParameters, ProjectParallelExecutionController projectParallelExecutionController, BuildTreeLifecycleListener lifecycleListener, InternalProblems problemsService, BuildOperationProgressEventEmitter eventEmitter, StartParameter startParameter, ProblemStream problemsStream, BuildStateRegistry buildStateRegistry, BuildActionRunner buildActionRunner) {
        this.buildModelParameters = buildModelParameters;
        this.projectParallelExecutionController = projectParallelExecutionController;
        this.lifecycleListener = lifecycleListener;
        this.problemsService = problemsService;
        this.eventEmitter = eventEmitter;
        this.startParameter = startParameter;
        this.problemsStream = problemsStream;
        this.buildActionRunner = buildActionRunner;
        this.buildStateRegistry = buildStateRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result execute(BuildAction action) {
        if (this.executed) {
            throw new IllegalStateException("Cannot execute a root build action more than once per build tree.");
        }
        this.executed = true;
        this.projectParallelExecutionController.startProjectExecution(this.buildModelParameters.isParallelProjectExecution());
        try {
            BuildActionRunner.Result result;
            this.lifecycleListener.afterStart();
            try {
                ProblemsProgressEventEmitterHolder.init((InternalProblems)this.problemsService);
                this.initDeprecationLogging();
                RootBuildLifecycleBuildActionExecutor.maybeNagOnDeprecatedJavaRuntimeVersion();
                RootBuildState rootBuild = this.buildStateRegistry.createRootBuild(BuildDefinition.fromStartParameter((StartParameterInternal)action.getStartParameter(), null));
                result = (BuildActionRunner.Result)rootBuild.run(buildController -> this.buildActionRunner.run(action, buildController));
            }
            catch (Throwable throwable) {
                this.lifecycleListener.beforeStop();
                throw throwable;
            }
            this.lifecycleListener.beforeStop();
            return result;
        }
        finally {
            this.projectParallelExecutionController.finishProjectExecution();
        }
    }

    private void initDeprecationLogging() {
        ShowStacktrace showStacktrace = this.startParameter.getShowStacktrace();
        LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((showStacktrace.equals((Object)ShowStacktrace.ALWAYS) || showStacktrace.equals((Object)ShowStacktrace.ALWAYS_FULL) ? 1 : 0) != 0);
        DeprecationLogger.init((WarningMode)this.startParameter.getWarningMode(), (BuildOperationProgressEventEmitter)this.eventEmitter, (Problems)this.problemsService, (ProblemStream)this.problemsStream);
    }

    private static void maybeNagOnDeprecatedJavaRuntimeVersion() {
        int currentMajor = Integer.parseInt(JavaVersion.current().getMajorVersion());
        if (currentMajor < 17) {
            int currentMajorGradleVersion = VersionNumber.parse((String)GradleVersion.current().getVersion()).getMajor();
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)String.format("Executing Gradle on JVM versions %d and lower", 16)).withContext(String.format("Use JVM %d or greater to execute Gradle. Projects can continue to use older JVM versions via toolchains.", 17))).willBecomeAnErrorInNextMajorGradleVersion().withUpgradeGuideSection(currentMajorGradleVersion, "minimum_daemon_jvm_version")).nagUser();
        }
    }
}

