/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.plugins.ExtraPropertiesExtensionInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.internal.Cast;
import org.jspecify.annotations.Nullable;

public class DefaultExtraPropertiesExtension
extends GroovyObjectSupport
implements ExtraPropertiesExtensionInternal {
    private @Nullable GradleProperties gradleProperties;
    private @Nullable Map<String, Object> storage = null;

    public boolean has(String name) {
        if (this.storage != null && this.storage.containsKey(name)) {
            return true;
        }
        if (this.gradleProperties != null) {
            return this.gradleProperties.findUnsafe(name) != null;
        }
        return false;
    }

    public @Nullable Object get(String name) {
        Object value = this.find(name);
        if (value == null && !this.has(name)) {
            throw new ExtraPropertiesExtension.UnknownPropertyException((ExtraPropertiesExtension)this, name);
        }
        return value;
    }

    private @Nullable Object find(String name) {
        Object value;
        if (this.storage != null && ((value = this.storage.get(name)) != null || this.storage.containsKey(name))) {
            return value;
        }
        if (this.gradleProperties != null) {
            return this.gradleProperties.findUnsafe(name);
        }
        return null;
    }

    public void set(String name, @Nullable Object value) {
        if (this.storage == null) {
            this.storage = new HashMap<String, Object>();
        }
        this.storage.put(name, value);
    }

    public @Nullable Object getProperty(String name) {
        Object value;
        if (name.equals("properties")) {
            return this.getProperties();
        }
        if (this.storage != null && ((value = this.storage.get(name)) != null || this.storage.containsKey(name))) {
            return value;
        }
        if (this.gradleProperties != null && (value = this.gradleProperties.findUnsafe(name)) != null) {
            return value;
        }
        throw new MissingPropertyException(ExtraPropertiesExtension.UnknownPropertyException.createMessage((String)name), name, null);
    }

    public void setProperty(String name, @Nullable Object newValue) {
        if (name.equals("properties")) {
            throw new ReadOnlyPropertyException("name", ExtraPropertiesExtension.class);
        }
        this.set(name, newValue);
    }

    public Map<String, Object> getProperties() {
        if (this.storage == null) {
            return new HashMap<String, Object>(this.getGradlePropertiesAsMap());
        }
        Map<String, Object> gradlePropertiesMap = this.getGradlePropertiesAsMap();
        HashMap<String, Object> properties = new HashMap<String, Object>(this.storage.size() + gradlePropertiesMap.size());
        properties.putAll(this.storage);
        for (Map.Entry<String, Object> entry : gradlePropertiesMap.entrySet()) {
            if (this.storage.containsKey(entry.getKey())) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    private Map<String, Object> getGradlePropertiesAsMap() {
        return this.gradleProperties == null ? Collections.emptyMap() : (Map)Cast.uncheckedNonnullCast((Object)this.gradleProperties.getProperties());
    }

    public Object methodMissing(String name, Object args) {
        Object item = this.find(name);
        if (item instanceof Closure) {
            Closure closure = (Closure)item;
            return closure.call((Object[])args);
        }
        throw new MissingMethodException(name, this.getClass(), (Object[])args);
    }

    @Override
    public void setGradleProperties(GradleProperties gradleProperties) {
        this.gradleProperties = gradleProperties;
    }
}

