/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.base.Equivalence;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Methods {
    public static final Equivalence<Method> SIGNATURE_EQUIVALENCE = new Equivalence<Method>(){

        protected boolean doEquivalent(Method a, Method b) {
            if (a.getName().equals(b.getName()) && (a.getReturnType().equals(b.getReturnType()) || a.getReturnType().isAssignableFrom(b.getReturnType()) || b.getReturnType().isAssignableFrom(a.getReturnType()))) {
                return Arrays.equals(a.getGenericParameterTypes(), b.getGenericParameterTypes());
            }
            return false;
        }

        protected int doHash(Method method) {
            return new HashCodeBuilder().append((Object)method.getName()).append((Object[])method.getParameterTypes()).toHashCode();
        }
    };
    public static final Equivalence<Method> DESCRIPTOR_EQUIVALENCE = new Equivalence<Method>(){

        protected boolean doEquivalent(Method a, Method b) {
            if (a.getName().equals(b.getName())) {
                return a.getGenericReturnType().equals(b.getGenericReturnType()) && Arrays.equals(a.getGenericParameterTypes(), b.getGenericParameterTypes());
            }
            return false;
        }

        protected int doHash(Method method) {
            return new HashCodeBuilder().append((Object)method.getName()).append((Object[])method.getParameterTypes()).append(method.getReturnType()).toHashCode();
        }
    };
}

