/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.Objects;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;
import org.gradle.tooling.provider.model.internal.ToolingModelParameterCarrier;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;
import org.jspecify.annotations.Nullable;

public class DefaultBuildToolingModelController
implements BuildToolingModelController {
    private final BuildLifecycleController buildController;
    private final BuildState buildState;
    private final ToolingModelBuilderLookup buildScopeLookup;

    public DefaultBuildToolingModelController(BuildState buildState, BuildLifecycleController buildController, ToolingModelBuilderLookup buildScopeLookup) {
        this.buildState = buildState;
        this.buildController = buildController;
        this.buildScopeLookup = buildScopeLookup;
    }

    @Override
    public GradleInternal getConfiguredModel() {
        return this.buildController.getConfiguredBuild();
    }

    @Override
    public ToolingModelScope locateBuilderForTarget(String modelName, boolean param) {
        ToolingModelBuilderLookup.Builder builder = this.buildScopeLookup.maybeLocateForBuildScope(modelName, param, this.buildState);
        if (builder != null) {
            return new BuildToolingScope(builder);
        }
        ProjectState targetProject = this.buildController.withProjectsConfigured(gradle -> gradle.getDefaultProject().getOwner());
        return this.doLocate(targetProject, modelName, param);
    }

    @Override
    public ToolingModelScope locateBuilderForTarget(ProjectState target, String modelName, boolean param) {
        if (target.getOwner() != this.buildState) {
            throw new IllegalArgumentException("Project has unexpected owner.");
        }
        this.configureProjectsForModel(target, modelName);
        return this.doLocate(target, modelName, param);
    }

    protected void configureProjectsForModel(ProjectState target, String modelName) {
        this.buildController.configureProjects();
    }

    protected ToolingModelScope doLocate(ProjectState target, String modelName, boolean param) {
        return new ProjectToolingScope(target, modelName, param);
    }

    private static class BuildToolingScope
    extends AbstractToolingScope {
        private final ToolingModelBuilderLookup.Builder builder;

        public BuildToolingScope(ToolingModelBuilderLookup.Builder builder) {
            this.builder = builder;
        }

        @Override
        public @Nullable ProjectState getTarget() {
            return null;
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            return this.builder;
        }
    }

    protected static class ProjectToolingScope
    extends AbstractToolingScope {
        protected final ProjectState targetProject;
        protected final String modelName;
        protected final boolean parameter;

        public ProjectToolingScope(ProjectState targetProject, String modelName, boolean parameter) {
            this.targetProject = targetProject;
            this.modelName = modelName;
            this.parameter = parameter;
        }

        @Override
        public @Nullable ProjectState getTarget() {
            return this.targetProject;
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            this.targetProject.ensureConfigured();
            ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)this.targetProject.getMutableModel().getServices().get(ToolingModelBuilderLookup.class);
            return lookup.locateForClientOperation(this.modelName, this.parameter, this.targetProject, this.targetProject.getMutableModel());
        }
    }

    private static abstract class AbstractToolingScope
    implements ToolingModelScope {
        private AbstractToolingScope() {
        }

        abstract ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException;

        @Override
        public Object getModel(String modelName, @Nullable ToolingModelParameterCarrier parameter) {
            ToolingModelBuilderLookup.Builder builder = this.locateBuilder();
            if (parameter == null) {
                return builder.build(null);
            }
            Class<?> expectedParameterType = Objects.requireNonNull(builder.getParameterType(), "Expected builder with parameter support");
            Object parameterValue = parameter.getView(expectedParameterType);
            return builder.build(parameterValue);
        }
    }
}

