/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchies;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchy;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.OrdinalNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.TextUtil;

public class MissingTaskDependencyDetector {
    private final ExecutionNodeAccessHierarchy outputHierarchy;
    private final ExecutionNodeAccessHierarchies.InputNodeAccessHierarchy inputHierarchy;
    private static final String IMPLICIT_DEPENDENCY = "IMPLICIT_DEPENDENCY";

    public MissingTaskDependencyDetector(ExecutionNodeAccessHierarchy outputHierarchy, ExecutionNodeAccessHierarchies.InputNodeAccessHierarchy inputHierarchy) {
        this.outputHierarchy = outputHierarchy;
        this.inputHierarchy = inputHierarchy;
    }

    public void visitUnfilteredInputLocation(LocalTaskNode node, TypeValidationContext validationContext, String location) {
        this.inputHierarchy.recordNodeAccessingLocation(node, location);
        MissingTaskDependencyDetector.collectValidationProblemsForConsumer(node, validationContext, location, this.outputHierarchy.getNodesAccessing(location));
    }

    public void visitFilteredInputLocation(LocalTaskNode node, TypeValidationContext validationContext, String location, Spec<FileTreeElement> spec) {
        this.inputHierarchy.recordNodeAccessingFileTree(node, location, spec);
        MissingTaskDependencyDetector.collectValidationProblemsForConsumer(node, validationContext, location, this.outputHierarchy.getNodesAccessing(location, spec));
    }

    public void visitOutputLocation(LocalTaskNode node, TypeValidationContext validationContext, String location) {
        MissingTaskDependencyDetector.collectValidationProblemsForProducer(node, validationContext, location, this.inputHierarchy.getNodesAccessing(location));
    }

    private static void collectValidationProblemsForConsumer(LocalTaskNode consumer, TypeValidationContext validationContext, String locationConsumedByThisTask, Collection<Node> producers) {
        producers.stream().filter(producerNode -> MissingTaskDependencyDetector.hasNoSpecifiedOrder(producerNode, consumer)).filter(MissingTaskDependencyDetector::isEnabled).forEach(producerWithoutDependency -> MissingTaskDependencyDetector.collectValidationProblem(producerWithoutDependency, consumer, validationContext, locationConsumedByThisTask));
    }

    private static void collectValidationProblemsForProducer(LocalTaskNode node, TypeValidationContext validationContext, String outputPath, Collection<Node> consumers) {
        consumers.stream().filter(consumerNode -> MissingTaskDependencyDetector.hasNoSpecifiedOrder(node, consumerNode)).filter(MissingTaskDependencyDetector::isEnabled).forEach(consumerWithoutDependency -> MissingTaskDependencyDetector.collectValidationProblem(node, consumerWithoutDependency, validationContext, outputPath));
    }

    private static boolean isEnabled(Node node) {
        if (node instanceof LocalTaskNode) {
            TaskInternal task = ((LocalTaskNode)node).getTask();
            return task.getOnlyIf().isSatisfiedBy((Object)task);
        }
        return false;
    }

    private static boolean hasNoSpecifiedOrder(Node producerNode, Node consumerNode) {
        return MissingTaskDependencyDetector.missesDependency(producerNode, consumerNode) && MissingTaskDependencyDetector.missesDependency(consumerNode, producerNode);
    }

    private static boolean missesDependency(Node producer, Node consumer) {
        if (consumer == producer) {
            return false;
        }
        if (consumer.getDependencySuccessors().contains(producer)) {
            return false;
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        HashSet<Node> seenNodes = new HashSet<Node>();
        MissingTaskDependencyDetector.addHardSuccessorTasksToQueue(consumer, seenNodes, queue);
        while (!queue.isEmpty()) {
            Node dependency = (Node)queue.removeFirst();
            if (dependency == producer) {
                return false;
            }
            MissingTaskDependencyDetector.addHardSuccessorTasksToQueue(dependency, seenNodes, queue);
        }
        return true;
    }

    private static void addHardSuccessorTasksToQueue(Node node, Set<Node> seenNodes, Queue<Node> queue) {
        node.getHardSuccessors().forEach(successor -> {
            if (successor instanceof TaskNode || successor instanceof OrdinalNode) {
                if (seenNodes.add((Node)successor)) {
                    queue.add((Node)successor);
                }
            } else {
                MissingTaskDependencyDetector.addHardSuccessorTasksToQueue(successor, seenNodes, queue);
            }
        });
    }

    private static void collectValidationProblem(Node producer, Node consumer, TypeValidationContext validationContext, String consumerProducerPath) {
        validationContext.visitPropertyProblem(problem -> problem.id(TextUtil.screamingSnakeToKebabCase((String)IMPLICIT_DEPENDENCY), "Property has implicit dependency", GradleCoreProblemGroup.validation().property()).contextualLabel("Gradle detected a problem with the following location: '" + consumerProducerPath + "'").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)IMPLICIT_DEPENDENCY.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details(String.format("Task '%s' uses this output of task '%s' without declaring an explicit or implicit dependency. This can lead to incorrect results being produced, depending on what order the tasks are executed", consumer, producer)).solution("Declare task '" + producer + "' as an input of '" + consumer + "'").solution("Declare an explicit dependency on '" + producer + "' from '" + consumer + "' using Task#dependsOn").solution("Declare an explicit dependency on '" + producer + "' from '" + consumer + "' using Task#mustRunAfter"));
    }
}

