/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.internal.BuildServiceDetails;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.api.services.internal.RegisteredBuildServiceProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.service.ServiceRegistry;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ConsumedBuildServiceProvider<T extends BuildService<BuildServiceParameters>>
extends BuildServiceProvider<T, BuildServiceParameters> {
    protected final ServiceRegistry internalServices;
    private final String serviceName;
    private final Class<T> serviceType;
    private final BuildIdentifier buildIdentifier;
    private volatile RegisteredBuildServiceProvider<T, BuildServiceParameters> resolvedProvider;

    public ConsumedBuildServiceProvider(BuildIdentifier buildIdentifier, String serviceName, Class<T> serviceType, ServiceRegistry internalServices) {
        this.buildIdentifier = buildIdentifier;
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.internalServices = internalServices;
    }

    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        RegisteredBuildServiceProvider<T, BuildServiceParameters> resolvedProvider = this.resolve(true);
        if (resolvedProvider == null) {
            return ValueSupplier.Value.missing();
        }
        return resolvedProvider.calculateValue(consumer);
    }

    public @Nullable RegisteredBuildServiceProvider<T, ?> resolveIfPossible() {
        this.resolve(false);
        return this.resolvedProvider;
    }

    private @Nullable RegisteredBuildServiceProvider<T, BuildServiceParameters> resolve(boolean failIfAmbiguous) {
        if (this.resolvedProvider == null) {
            BuildServiceRegistry buildServiceRegistry = (BuildServiceRegistry)this.internalServices.get(BuildServiceRegistry.class);
            Set<BuildServiceRegistration<?, ?>> results = ((BuildServiceRegistryInternal)buildServiceRegistry).findRegistrations(this.getType(), this.getName());
            if (results.isEmpty()) {
                return null;
            }
            if (results.size() > 1) {
                if (!failIfAmbiguous) {
                    return null;
                }
                String names = results.stream().map(it -> it.getName() + ": " + ConsumedBuildServiceProvider.getProvidedType(it.getService()).getTypeName()).collect(Collectors.joining(", "));
                throw new IllegalArgumentException(String.format("Cannot resolve service by type for type '%s' when there are two or more instances. Please also provide a service name. Instances found: %s.", this.getType().getTypeName(), names));
            }
            this.resolvedProvider = (RegisteredBuildServiceProvider)((Object)Cast.uncheckedCast((Object)((BuildServiceRegistration)results.stream().findFirst().get()).getService()));
        }
        return this.resolvedProvider;
    }

    @Override
    public @NonNull Class<T> getType() {
        return this.serviceType;
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public BuildServiceDetails<T, BuildServiceParameters> getServiceDetails() {
        RegisteredBuildServiceProvider<T, BuildServiceParameters> resolvedProvider = this.resolve(true);
        return resolvedProvider != null ? ((BuildServiceProvider)resolvedProvider).getServiceDetails() : new BuildServiceDetails(this.buildIdentifier, this.serviceName, this.serviceType);
    }

    public ProviderInternal<T> withFinalValue(ValueSupplier.ValueConsumer consumer) {
        RegisteredBuildServiceProvider<T, BuildServiceParameters> resolved = this.resolve(true);
        return resolved != null ? resolved.withFinalValue(consumer) : super.withFinalValue(consumer);
    }

    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.resolve(false) != null;
    }
}

