/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import java.util.OptionalLong;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;

public final class OutputTrackedResult {
    private final OutputEntry outputEntry;
    private final SerializableTestResult testResult;
    private final long parentId;

    OutputTrackedResult(OutputEntry outputEntry, SerializableTestResult testResult, long parentId) {
        this.outputEntry = outputEntry;
        this.testResult = testResult;
        this.parentId = parentId;
    }

    public SerializableTestResult getInnerResult() {
        return this.testResult;
    }

    public long getId() {
        return this.outputEntry.id;
    }

    public OutputEntry getOutputEntry() {
        return this.outputEntry;
    }

    public OptionalLong getParentId() {
        return this.parentId == 0L ? OptionalLong.empty() : OptionalLong.of(this.parentId);
    }

    public OutputTrackedResult withInnerResult(SerializableTestResult newInnerResult) {
        return new OutputTrackedResult(this.outputEntry, newInnerResult, this.parentId);
    }
}

