/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import com.google.common.collect.MapMaker;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.DelegatingClassLoader;
import org.jspecify.annotations.Nullable;

public class CachingClassLoader
extends ClassLoader
implements DelegatingClassLoader,
ClassLoaderHierarchy,
Closeable {
    private static final Object MISSING = new Object();
    private final ConcurrentMap<String, Object> loadedClasses = new MapMaker().weakValues().makeMap();
    private final ConcurrentMap<String, Object> resources = new MapMaker().makeMap();
    private final ClassLoader parent;

    public CachingClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        Object cachedValue = this.loadedClasses.get(name);
        if (cachedValue instanceof Class) {
            return (Class)cachedValue;
        }
        if (cachedValue == MISSING) {
            throw new ClassNotFoundException(name);
        }
        try {
            result = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            this.loadedClasses.putIfAbsent(name, MISSING);
            throw e;
        }
        this.loadedClasses.putIfAbsent(name, result);
        return result;
    }

    @Override
    public @Nullable URL getResource(String name) {
        Object cachedValue = this.resources.get(name);
        if (cachedValue == MISSING) {
            return null;
        }
        if (cachedValue != null) {
            return (URL)cachedValue;
        }
        URL result = super.getResource(name);
        this.resources.putIfAbsent(name, result != null ? result : MISSING);
        return result;
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec());
        visitor.visitParent(this.getParent());
    }

    @Override
    public void close() throws IOException {
        this.loadedClasses.clear();
        this.resources.clear();
    }

    public String toString() {
        return CachingClassLoader.class.getSimpleName() + "(" + this.getParent() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachingClassLoader)) {
            return false;
        }
        CachingClassLoader that = (CachingClassLoader)o;
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return this.parent.hashCode();
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static class Spec
    extends ClassLoaderSpec {
        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(Spec.class);
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }
    }
}

