/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.logging.JavaClassNameFormatter;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TestEventProgressListener
implements TestListenerInternal {
    private static final int MAX_TEST_NAME_LENGTH = 60;
    private final ProgressLoggerFactory factory;
    private final Map<Object, ProgressLogger> progressLoggers = new ConcurrentHashMap<Object, ProgressLogger>();

    public TestEventProgressListener(ProgressLoggerFactory factory) {
        this.factory = factory;
    }

    @Override
    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
        ProgressLogger progressLogger;
        if (testDescriptor.getParent() == null) {
            progressLogger = this.factory.newOperation(TestEventProgressListener.class);
        } else {
            ProgressLogger parentProgressLogger = this.progressLoggers.get(testDescriptor.getParent().getId());
            assert (parentProgressLogger != null);
            progressLogger = this.factory.newOperation(TestEventProgressListener.class, parentProgressLogger);
        }
        String description = testDescriptor.isComposite() ? testDescriptor.getDisplayName() : "Executing test " + JavaClassNameFormatter.abbreviateJavaPackage(testDescriptor.getDisplayName(), 60);
        progressLogger.start(description, description);
        this.progressLoggers.put(testDescriptor.getId(), progressLogger);
    }

    @Override
    public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
        ProgressLogger progressLogger = this.progressLoggers.remove(testDescriptor.getId());
        assert (progressLogger != null);
        progressLogger.completed();
    }

    @Override
    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
    }

    @Override
    public void metadata(TestDescriptorInternal testDescriptor, TestMetadataEvent event) {
    }
}

