/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.gradle.api.internal.tasks.testing.DefaultNestedTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultParameterizedTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestMetadataEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.failure.DefaultThrowableToTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertjMultipleAssertionsErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.JUnitComparisonTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestAssertionFailedMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestMultipleFailuresErrorMapper;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.Cast;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.id.CompositeIdGenerator;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class JUnitPlatformTestExecutionListener
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitPlatformTestExecutionListener.class);
    private static final List<TestFailureMapper> MAPPERS = Arrays.asList(new OpenTestAssertionFailedMapper(), new OpenTestMultipleFailuresErrorMapper(), new JUnitComparisonTestFailureMapper(), new AssertjMultipleAssertionsErrorMapper(), new AssertErrorMapper());
    private static final DefaultThrowableToTestFailureMapper FAILURE_MAPPER = new DefaultThrowableToTestFailureMapper(MAPPERS);
    private static final boolean HAS_GET_UNIQUE_ID_OBJECT_METHOD = Arrays.stream(TestIdentifier.class.getMethods()).anyMatch(method -> method.getName().equals("getUniqueIdObject"));
    private final ConcurrentMap<String, TestDescriptorInternal> descriptorsByUniqueId = new ConcurrentHashMap<String, TestDescriptorInternal>();
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final IdGenerator<?> idGenerator;
    private final File baseDefinitionsDir;
    private @Nullable TestPlan currentTestPlan;

    private static UniqueId.Segment getLastUniqueIdSegment(TestIdentifier testIdentifier) {
        UniqueId uniqueIdObject = HAS_GET_UNIQUE_ID_OBJECT_METHOD ? testIdentifier.getUniqueIdObject() : UniqueId.parse((String)testIdentifier.getUniqueId());
        List segments = uniqueIdObject.getSegments();
        return (UniqueId.Segment)segments.get(segments.size() - 1);
    }

    private static boolean isEngineNode(TestIdentifier testIdentifier) {
        String lastSegmentType = JUnitPlatformTestExecutionListener.getLastUniqueIdSegment(testIdentifier).getType();
        return "engine".equals(lastSegmentType);
    }

    public JUnitPlatformTestExecutionListener(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator, File baseDefinitionsDir) {
        this.resultProcessor = resultProcessor;
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.baseDefinitionsDir = baseDefinitionsDir;
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        if (this.wasStarted(testIdentifier)) {
            this.resultProcessor.published(this.getId(testIdentifier), (TestMetadataEvent)new DefaultTestMetadataEvent(entry.getTimestamp().toEpochSecond(ZoneOffset.UTC), (Map)Cast.uncheckedNonnullCast((Object)entry.getKeyValuePairs())));
        } else {
            Object closestStartedAncestor = this.getIdOfClosestStartedAncestor(testIdentifier);
            if (closestStartedAncestor != null) {
                this.resultProcessor.published(closestStartedAncestor, (TestMetadataEvent)new DefaultTestMetadataEvent(entry.getTimestamp().toEpochSecond(ZoneOffset.UTC), (Map)Cast.uncheckedNonnullCast((Object)entry.getKeyValuePairs())));
            }
            LOGGER.debug("report entry published for unknown test identifier {}", (Object)testIdentifier);
        }
    }

    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry file) {
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.currentTestPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.currentTestPlan = null;
        this.descriptorsByUniqueId.clear();
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionSkipped(testIdentifier);
    }

    private void executionSkipped(TestIdentifier testIdentifier) {
        this.executionStarted(testIdentifier);
        this.reportSkipped(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.getParentId().isPresent() && !JUnitPlatformTestExecutionListener.isEngineNode(testIdentifier)) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            testExecutionResult.getThrowable().ifPresent(throwable -> this.resultProcessor.failure(this.getId(testIdentifier), DefaultTestFailure.fromTestAssumptionFailure((Throwable)throwable)));
            this.reportSkipped(testIdentifier);
            return;
        }
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.reportStartedUnlessAlreadyStarted(testIdentifier);
            Throwable failure = testExecutionResult.getThrowable().orElseGet(() -> new AssertionError((Object)"test failed but did not report an exception"));
            if (testIdentifier.isTest()) {
                this.reportTestFailure(testIdentifier, failure);
            } else {
                TestDescriptorInternal syntheticTestDescriptor = this.createSyntheticTestDescriptorForContainer(testIdentifier);
                this.resultProcessor.started(syntheticTestDescriptor, this.startEvent(this.getId(testIdentifier)));
                this.resultProcessor.failure(syntheticTestDescriptor.getId(), TestFailure.fromTestFrameworkFailure((Throwable)failure));
                this.resultProcessor.completed(syntheticTestDescriptor.getId(), this.completeEvent());
            }
        }
        if (this.wasStarted(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private void reportTestFailure(TestIdentifier testIdentifier, Throwable failure) {
        TestFailure testFailure = FAILURE_MAPPER.createFailure(failure);
        this.resultProcessor.failure(this.getId(testIdentifier), testFailure);
    }

    private void reportStartedUnlessAlreadyStarted(TestIdentifier testIdentifier) {
        boolean wasNotAlreadyStarted = this.createDescriptorIfAbsent(testIdentifier);
        if (wasNotAlreadyStarted) {
            TestDescriptorInternal descriptor = (TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId());
            this.resultProcessor.started(descriptor, this.startEvent(testIdentifier));
        }
    }

    private void reportSkipped(TestIdentifier testIdentifier) {
        Objects.requireNonNull(this.currentTestPlan);
        this.currentTestPlan.getChildren(testIdentifier).stream().filter(child -> !this.wasStarted((TestIdentifier)child)).forEach(this::executionSkipped);
        if (testIdentifier.isTest()) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent(TestResult.ResultType.SKIPPED));
        } else if (JUnitPlatformTestExecutionListener.hasClassSource(testIdentifier)) {
            this.resultProcessor.completed(this.getId(testIdentifier), this.completeEvent());
        }
    }

    private TestStartEvent startEvent(TestIdentifier testIdentifier) {
        Object idOfClosestStartedAncestor = this.getIdOfClosestStartedAncestor(testIdentifier);
        return this.startEvent(idOfClosestStartedAncestor);
    }

    private @Nullable Object getIdOfClosestStartedAncestor(TestIdentifier testIdentifier) {
        return this.getAncestors(testIdentifier).stream().map(TestIdentifier::getUniqueId).filter(this.descriptorsByUniqueId::containsKey).findFirst().map(this.descriptorsByUniqueId::get).map(TestDescriptorInternal::getId).orElse(null);
    }

    private TestStartEvent startEvent(@Nullable Object parentId) {
        return new TestStartEvent(this.clock.getCurrentTime(), parentId);
    }

    private TestCompleteEvent completeEvent() {
        return this.completeEvent(null);
    }

    private TestCompleteEvent completeEvent(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TestResult.ResultType resultType) {
        return new TestCompleteEvent(this.clock.getCurrentTime(), resultType);
    }

    private boolean wasStarted(TestIdentifier testIdentifier) {
        return this.descriptorsByUniqueId.containsKey(testIdentifier.getUniqueId());
    }

    private boolean createDescriptorIfAbsent(TestIdentifier node) {
        MutableBoolean wasCreated = new MutableBoolean(false);
        this.descriptorsByUniqueId.computeIfAbsent(node.getUniqueId(), uniqueId -> {
            wasCreated.set(true);
            boolean isTestClassId = this.isTestClassIdentifier(node);
            if (node.getType().isContainer() || isTestClassId) {
                Object candidateId;
                if (isTestClassId) {
                    return this.createTestContainerDescriptor(node);
                }
                String displayName = node.getDisplayName();
                Optional<TestDescriptorInternal> parentId = node.getParentId().map(this.descriptorsByUniqueId::get);
                if (parentId.isPresent() && (candidateId = parentId.get().getId()) instanceof CompositeIdGenerator.CompositeId) {
                    return this.createNestedTestSuite(node, displayName, (CompositeIdGenerator.CompositeId)candidateId);
                }
            }
            if (node.getType().isTest()) {
                return this.createTestDescriptor(node, node.getLegacyReportingName(), node.getDisplayName());
            }
            return this.createTestContainerDescriptor(node);
        });
        return wasCreated.get();
    }

    private DefaultTestSuiteDescriptor createNestedTestSuite(TestIdentifier node, String displayName, CompositeIdGenerator.CompositeId candidateId) {
        Optional<MethodSource> methodSource = JUnitPlatformTestExecutionListener.getMethodSource(node);
        if (methodSource.isPresent()) {
            TestDescriptorInternal parentDescriptor = this.findTestParentDescriptor(node);
            String className = parentDescriptor == null ? "UnknownClass" : parentDescriptor.getName();
            return new DefaultParameterizedTestDescriptor(this.idGenerator.generateId(), node.getLegacyReportingName(), className, displayName, candidateId);
        }
        return new DefaultNestedTestSuiteDescriptor(this.idGenerator.generateId(), node.getLegacyReportingName(), displayName, candidateId);
    }

    private DefaultTestClassDescriptor createTestContainerDescriptor(TestIdentifier node) {
        String name = this.extractClassOrResourceName(node);
        String classDisplayName = node.getDisplayName();
        return new DefaultTestClassDescriptor(this.idGenerator.generateId(), name, classDisplayName);
    }

    private TestDescriptorInternal createSyntheticTestDescriptorForContainer(TestIdentifier node) {
        assert (this.currentTestPlan != null);
        boolean testsStarted = this.currentTestPlan.getDescendants(node).stream().anyMatch(this::wasStarted);
        String name = testsStarted ? "executionError" : "initializationError";
        return this.createTestDescriptor(node, name, name);
    }

    private TestDescriptorInternal createTestDescriptor(TestIdentifier test, String name, String displayName) {
        TestDescriptorInternal parentDescriptor = this.findTestParentDescriptor(test);
        String className = parentDescriptor == null ? "UnknownClass" : parentDescriptor.getName();
        String classDisplayName = parentDescriptor == null ? "UnknownClass" : parentDescriptor.getClassDisplayName();
        return new DefaultTestDescriptor(this.idGenerator.generateId(), className, name, classDisplayName, displayName);
    }

    private Object getId(TestIdentifier testIdentifier) {
        return ((TestDescriptorInternal)this.descriptorsByUniqueId.get(testIdentifier.getUniqueId())).getId();
    }

    private Set<TestIdentifier> getAncestors(TestIdentifier testIdentifier) {
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>();
        Optional<TestIdentifier> parent = this.getParent(testIdentifier);
        while (parent.isPresent()) {
            result.add(parent.get());
            parent = this.getParent(parent.get());
        }
        return result;
    }

    private @Nullable TestIdentifier findTestClassIdentifier(TestIdentifier testIdentifier) {
        return this.findInAncestors(testIdentifier, identifier -> this.isTestClassIdentifier((TestIdentifier)identifier) ? identifier : null);
    }

    private @Nullable TestDescriptorInternal findTestParentDescriptor(TestIdentifier testIdentifier) {
        TestIdentifier classIdentifier = this.findTestClassIdentifier(testIdentifier);
        if (classIdentifier != null) {
            return (TestDescriptorInternal)this.descriptorsByUniqueId.get(classIdentifier.getUniqueId());
        }
        return this.findInAncestors(testIdentifier, identifier -> (TestDescriptorInternal)this.descriptorsByUniqueId.get(identifier.getUniqueId()));
    }

    private <T> @Nullable T findInAncestors(TestIdentifier testIdentifier, Function<TestIdentifier, @Nullable T> mapper) {
        TestIdentifier current = testIdentifier;
        while (current != null && !JUnitPlatformTestExecutionListener.isEngineNode(current)) {
            T result = mapper.apply(current);
            if (result != null) {
                return result;
            }
            current = this.getParent(current).orElse(null);
        }
        return null;
    }

    private Optional<TestIdentifier> getParent(TestIdentifier testIdentifier) {
        Objects.requireNonNull(this.currentTestPlan);
        try {
            return testIdentifier.getParentIdObject().map(arg_0 -> ((TestPlan)this.currentTestPlan).getTestIdentifier(arg_0));
        }
        catch (BootstrapMethodError | NoSuchMethodError ignore) {
            return testIdentifier.getParentId().map(arg_0 -> ((TestPlan)this.currentTestPlan).getTestIdentifier(arg_0));
        }
    }

    private boolean isTestClassIdentifier(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.hasClassSource(testIdentifier) && this.hasDifferentSourceThanAncestor(testIdentifier);
    }

    private String extractClassOrResourceName(TestIdentifier node) {
        Optional<String> fileSourceName;
        Optional<ClassSource> classSource;
        TestIdentifier testClassIdentifier = this.findTestClassIdentifier(node);
        if (testClassIdentifier != null && (classSource = JUnitPlatformTestExecutionListener.getClassSource(testClassIdentifier)).isPresent()) {
            return classSource.get().getClassName();
        }
        if (JUnitPlatformTestExecutionListener.hasFileSource(node) && (fileSourceName = this.computeNameForFileBasedTest(node)).isPresent()) {
            return fileSourceName.get();
        }
        UniqueId.Segment lastSegment = JUnitPlatformTestExecutionListener.getLastUniqueIdSegment(node);
        return (lastSegment.getType() + "_" + lastSegment.getValue()).replace(':', '_');
    }

    private Optional<String> computeNameForFileBasedTest(TestIdentifier node) {
        Object source = node.getSource().orElse(null);
        if (!(source instanceof FileSource)) {
            throw new IllegalArgumentException("Node source must be a FileSource, was: " + source);
        }
        try {
            Path rootDirPath = this.baseDefinitionsDir.toPath().toRealPath(new LinkOption[0]);
            Path testDefPath = ((FileSource)source).getFile().toPath().toRealPath(new LinkOption[0]);
            String relativePath = TextUtil.normaliseFileSeparators((String)rootDirPath.relativize(testDefPath).toString());
            return Optional.of(relativePath);
        }
        catch (IOException e) {
            LOGGER.warn("Could not compute relative path to source file for test identifier {}", (Object)node, (Object)e);
            return Optional.empty();
        }
    }

    private static boolean hasClassSource(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.getClassSource(testIdentifier).isPresent();
    }

    private static Optional<ClassSource> getClassSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(source -> source instanceof ClassSource).map(source -> (ClassSource)source);
    }

    private static Optional<MethodSource> getMethodSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(source -> source instanceof MethodSource).map(source -> (MethodSource)source);
    }

    private static boolean hasFileSource(TestIdentifier testIdentifier) {
        return JUnitPlatformTestExecutionListener.getFileSource(testIdentifier).isPresent();
    }

    private static Optional<FileSource> getFileSource(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(source -> source instanceof FileSource).map(source -> (FileSource)source);
    }

    private boolean hasDifferentSourceThanAncestor(TestIdentifier testIdentifier) {
        Objects.requireNonNull(this.currentTestPlan);
        Optional parent = this.currentTestPlan.getParent(testIdentifier);
        while (parent.isPresent()) {
            if (Objects.equals(((TestIdentifier)parent.get()).getSource(), testIdentifier.getSource())) {
                return false;
            }
            parent = this.currentTestPlan.getParent((TestIdentifier)parent.get());
        }
        return true;
    }
}

