/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.scopes;

import java.io.File;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.cache.internal.scopes.DefaultCacheScopeMapping;
import org.gradle.cache.scopes.ScopedCacheBuilderFactory;
import org.gradle.util.GradleVersion;

public abstract class AbstractScopedCacheBuilderFactory
implements ScopedCacheBuilderFactory {
    private final CacheScopeMapping cacheScopeMapping;
    private final UnscopedCacheBuilderFactory unscopedCacheBuilderFactory;
    private final File rootDir;

    public AbstractScopedCacheBuilderFactory(File rootDir, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory) {
        this.rootDir = rootDir;
        this.cacheScopeMapping = new DefaultCacheScopeMapping(rootDir, GradleVersion.current());
        this.unscopedCacheBuilderFactory = unscopedCacheBuilderFactory;
    }

    protected UnscopedCacheBuilderFactory getCacheRepository() {
        return this.unscopedCacheBuilderFactory;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public CacheBuilder createCacheBuilder(String key) {
        return this.unscopedCacheBuilderFactory.cache(this.baseDirForCache(key));
    }

    @Override
    public CacheBuilder createCrossVersionCacheBuilder(String key) {
        return this.unscopedCacheBuilderFactory.cache(this.baseDirForCrossVersionCache(key));
    }

    @Override
    public File baseDirForCache(String key) {
        return this.cacheScopeMapping.getBaseDirectory(this.rootDir, key, VersionStrategy.CachePerVersion);
    }

    @Override
    public File baseDirForCrossVersionCache(String key) {
        return this.cacheScopeMapping.getBaseDirectory(this.rootDir, key, VersionStrategy.SharedCache);
    }
}

