/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.ir;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/ir/KlibSymbols;", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;)V", "findSharedVariableBoxClass", "Lorg/jetbrains/kotlin/backend/common/ir/KlibSymbols$SharedVariableBoxClassInfo;", "suffix", "", "genericSharedVariableBox", "getGenericSharedVariableBox", "()Lorg/jetbrains/kotlin/backend/common/ir/KlibSymbols$SharedVariableBoxClassInfo;", "primitiveSharedVariableBoxes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getPrimitiveSharedVariableBoxes", "()Ljava/util/Map;", "SharedVariableBoxClassInfo", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nSymbols.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Symbols.kt\norg/jetbrains/kotlin/backend/common/ir/KlibSymbols\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1193#2,2:284\n1267#2,4:286\n*S KotlinDebug\n*F\n+ 1 Symbols.kt\norg/jetbrains/kotlin/backend/common/ir/KlibSymbols\n*L\n279#1:284,2\n279#1:286,4\n*E\n"})
public abstract class KlibSymbols
extends Symbols {
    @NotNull
    private final SharedVariableBoxClassInfo genericSharedVariableBox;
    @NotNull
    private final Map<IrType, SharedVariableBoxClassInfo> primitiveSharedVariableBoxes;

    /*
     * WARNING - void declaration
     */
    public KlibSymbols(@NotNull IrBuiltIns irBuiltIns) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        super(irBuiltIns);
        this.genericSharedVariableBox = this.findSharedVariableBoxClass("");
        Iterable iterable = (Iterable)PrimitiveType.getEntries();
        KlibSymbols klibSymbols = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            PrimitiveType it = (PrimitiveType)((Object)element$iv$iv);
            boolean bl = false;
            IrType irType = irBuiltIns.getPrimitiveTypeToIrType().get((Object)it);
            Intrinsics.checkNotNull((Object)irType);
            String string = it.getTypeName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            Pair pair = TuplesKt.to((Object)irType, (Object)this.findSharedVariableBoxClass(string));
            map.put(pair.getFirst(), pair.getSecond());
        }
        klibSymbols.primitiveSharedVariableBoxes = destination$iv$iv;
    }

    private final SharedVariableBoxClassInfo findSharedVariableBoxClass(String suffix) {
        Name name2 = Name.identifier("SharedVariableBox" + suffix);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        ClassId classId = new ClassId(StandardNames.KOTLIN_INTERNAL_FQ_NAME, name2);
        IrClassSymbol irClassSymbol = this.getSymbolFinder().findClass(classId);
        if (irClassSymbol == null) {
            throw new IllegalStateException(("Could not find class " + classId).toString());
        }
        IrClassSymbol boxClass = irClassSymbol;
        return new SharedVariableBoxClassInfo(boxClass);
    }

    @NotNull
    public final SharedVariableBoxClassInfo getGenericSharedVariableBox() {
        return this.genericSharedVariableBox;
    }

    @NotNull
    public final Map<IrType, SharedVariableBoxClassInfo> getPrimitiveSharedVariableBoxes() {
        return this.primitiveSharedVariableBoxes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/ir/KlibSymbols$SharedVariableBoxClassInfo;", "", "klass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;)V", "getKlass", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "constructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getConstructor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "constructor$delegate", "Lkotlin/Lazy;", "load", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getLoad", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "load$delegate", "store", "getStore", "store$delegate", "ir.backend.common"})
    public static final class SharedVariableBoxClassInfo {
        @NotNull
        private final IrClassSymbol klass;
        @NotNull
        private final Lazy constructor$delegate;
        @NotNull
        private final Lazy load$delegate;
        @NotNull
        private final Lazy store$delegate;

        public SharedVariableBoxClassInfo(@NotNull IrClassSymbol klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            this.klass = klass;
            this.constructor$delegate = LazyKt.lazy(() -> SharedVariableBoxClassInfo.constructor_delegate$lambda$0(this));
            this.load$delegate = LazyKt.lazy(() -> SharedVariableBoxClassInfo.load_delegate$lambda$0(this));
            this.store$delegate = LazyKt.lazy(() -> SharedVariableBoxClassInfo.store_delegate$lambda$0(this));
        }

        @NotNull
        public final IrClassSymbol getKlass() {
            return this.klass;
        }

        @NotNull
        public final IrConstructorSymbol getConstructor() {
            Lazy lazy = this.constructor$delegate;
            return (IrConstructorSymbol)lazy.getValue();
        }

        @NotNull
        public final IrSimpleFunctionSymbol getLoad() {
            Lazy lazy = this.load$delegate;
            return (IrSimpleFunctionSymbol)lazy.getValue();
        }

        @NotNull
        public final IrSimpleFunctionSymbol getStore() {
            Lazy lazy = this.store$delegate;
            return (IrSimpleFunctionSymbol)lazy.getValue();
        }

        private static final IrConstructorSymbol constructor_delegate$lambda$0(SharedVariableBoxClassInfo this$0) {
            return (IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(this$0.klass));
        }

        private static final IrSimpleFunctionSymbol load_delegate$lambda$0(SharedVariableBoxClassInfo this$0) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(this$0.klass, "element");
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            return irSimpleFunctionSymbol;
        }

        private static final IrSimpleFunctionSymbol store_delegate$lambda$0(SharedVariableBoxClassInfo this$0) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertySetter(this$0.klass, "element");
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            return irSimpleFunctionSymbol;
        }
    }
}

