/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent.connector;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.LibraryHolder;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageantLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(PageantLibrary.class);
    private static final String PAGEANT = "Pageant";
    private static final int PAGEANT_ID = -2142351174;

    boolean isPageantAvailable() {
        LibraryHolder libs = LibraryHolder.getLibrary();
        if (libs == null) {
            return false;
        }
        WinDef.HWND window = libs.user.FindWindow(PAGEANT, PAGEANT);
        return window != null && !window.equals((Object)WinBase.INVALID_HANDLE_VALUE);
    }

    Pipe createPipe(String name, int maxSize) throws IOException {
        LibraryHolder libs = LibraryHolder.getLibrary();
        if (libs == null) {
            throw new IllegalStateException("Libraries were not loaded");
        }
        WinDef.HWND window = libs.user.FindWindow(PAGEANT, PAGEANT);
        if (window == null || window.equals((Object)WinBase.INVALID_HANDLE_VALUE)) {
            throw new IOException(Texts.get().msgPageantUnavailable);
        }
        String fileName = name + libs.kernel.GetCurrentThreadId();
        WinNT.HANDLE file = null;
        Pointer sharedMemory = null;
        try {
            file = libs.kernel.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, 4, 0, maxSize, fileName);
            if (file == null || file.equals((Object)WinBase.INVALID_HANDLE_VALUE)) {
                throw new IOException(libs.systemError(Texts.get().msgNoMappedFile));
            }
            sharedMemory = libs.kernel.MapViewOfFile(file, 2, 0, 0, 0);
            if (sharedMemory == null) {
                throw new IOException(libs.systemError(Texts.get().msgNoSharedMemory));
            }
            return new PipeImpl(libs, window, fileName, file, sharedMemory);
        }
        catch (IOException e) {
            PageantLibrary.close(libs, file, sharedMemory, true);
            throw e;
        }
        catch (Throwable e) {
            PageantLibrary.close(libs, file, sharedMemory, true);
            throw new IOException(Texts.get().msgSharedMemoryFailed, e);
        }
    }

    private static void close(LibraryHolder libs, WinNT.HANDLE file, Pointer memory, boolean silent) throws IOException {
        String msg;
        if (memory != null && !libs.kernel.UnmapViewOfFile(memory)) {
            msg = libs.systemError(Texts.get().errReleaseSharedMemory);
            if (silent) {
                LOG.error(msg);
            } else {
                throw new IOException(msg);
            }
        }
        if (file != null && !libs.kernel.CloseHandle(file)) {
            msg = libs.systemError(Texts.get().errCloseMappedFile);
            if (silent) {
                LOG.error(msg);
            } else {
                throw new IOException(msg);
            }
        }
    }

    public static class CopyStruct
    extends Structure {
        public int dwData = -2142351174;
        public long cbData;
        public Pointer lpData;

        protected List<String> getFieldOrder() {
            return List.of("dwData", "cbData", "lpData");
        }
    }

    static interface Pipe
    extends Closeable {
        public void send(byte[] var1) throws IOException;

        public void receive(byte[] var1) throws IOException;
    }

    private static class PipeImpl
    implements Pipe {
        private final LibraryHolder libs;
        private final WinDef.HWND window;
        private final byte[] name;
        private final WinNT.HANDLE file;
        private final Pointer memory;
        private long readPos = 0L;

        PipeImpl(LibraryHolder libs, WinDef.HWND window, String name, WinNT.HANDLE file, Pointer memory) {
            this.libs = libs;
            this.window = window;
            this.name = name.getBytes(StandardCharsets.US_ASCII);
            this.file = file;
            this.memory = memory;
        }

        @Override
        public void close() throws IOException {
            PageantLibrary.close(this.libs, this.file, this.memory, false);
        }

        private Pointer init(CopyStruct c) {
            c.cbData = (long)this.name.length + 1L;
            c.lpData = new Memory(c.cbData);
            c.lpData.write(0L, this.name, 0, this.name.length);
            c.lpData.setByte((long)this.name.length, (byte)0);
            c.write();
            return c.getPointer();
        }

        @Override
        public void send(byte[] message) throws IOException {
            this.memory.write(0L, message, 0, message.length);
            CopyStruct c = new CopyStruct();
            Pointer p = this.init(c);
            WinDef.LRESULT result = this.libs.user.SendMessage(this.window, 74, null, new WinDef.LPARAM(Pointer.nativeValue((Pointer)p)));
            if (result == null || result.longValue() == 0L) {
                throw new IOException(this.libs.systemError(Texts.get().msgSendFailed2));
            }
        }

        @Override
        public void receive(byte[] data) throws IOException {
            this.memory.read(this.readPos, data, 0, data.length);
            this.readPos += (long)data.length;
        }
    }
}

