/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.configuration.CompileOperationFactory;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.Actions;
import org.gradle.plugin.devel.internal.precompiled.FirstPassPrecompiledScript;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledGroovyScript;

@CacheableTask
public abstract class ExtractPluginRequestsTask
extends DefaultTask {
    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract ClassLoaderScopeRegistry getClassLoaderScopeRegistry();

    @Inject
    protected abstract ScriptCompilationHandler getScriptCompilationHandler();

    @Inject
    protected abstract CompileOperationFactory getCompileOperationFactory();

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    abstract ConfigurableFileCollection getScriptFiles();

    @OutputDirectory
    abstract DirectoryProperty getExtractedPluginRequestsClassesDirectory();

    @OutputDirectory
    abstract DirectoryProperty getExtractedPluginRequestsClassesStagingDirectory();

    @Internal
    abstract ListProperty<PrecompiledGroovyScript> getScriptPlugins();

    @TaskAction
    void extractPluginsBlocks() {
        this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{this.getExtractedPluginRequestsClassesDirectory()}));
        ((Directory)this.getExtractedPluginRequestsClassesDirectory().get()).getAsFile().mkdirs();
        for (PrecompiledGroovyScript scriptPlugin : (List)this.getScriptPlugins().get()) {
            this.compilePluginsBlock(scriptPlugin);
        }
    }

    private void compilePluginsBlock(PrecompiledGroovyScript scriptPlugin) {
        ClassLoaderScope classLoaderScope = this.getClassLoaderScopeRegistry().getCoreAndPluginsScope();
        CompileOperation pluginsCompileOperation = this.getCompileOperationFactory().getPluginsBlockCompileOperation(scriptPlugin.getScriptTarget());
        File outputDir = ((Directory)this.getExtractedPluginRequestsClassesDirectory().get()).dir(scriptPlugin.getId()).getAsFile();
        this.getScriptCompilationHandler().compileToDir(scriptPlugin.getFirstPassSource(), classLoaderScope.getExportClassLoader(), outputDir, outputDir, pluginsCompileOperation, FirstPassPrecompiledScript.class, Actions.doNothing());
        this.getFileSystemOperations().sync(copySpec -> {
            copySpec.from(new Object[]{this.getExtractedPluginRequestsClassesDirectory().getAsFileTree().getFiles()}).include(new String[]{"**.class"});
            copySpec.into((Object)this.getExtractedPluginRequestsClassesStagingDirectory());
        });
    }
}

