/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.PropertyListTransformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeBinary;
import org.gradle.ide.xcode.internal.XcodePropertyAdapter;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.XcodeUtils;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXBuildFile;
import org.gradle.ide.xcode.internal.xcodeproj.PBXFileReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXGroup;
import org.gradle.ide.xcode.internal.xcodeproj.PBXLegacyTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXNativeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXProject;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXShellScriptBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXSourcesBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.internal.xcodeproj.XCBuildConfiguration;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.gradle.ide.xcode.tasks.internal.XcodeProjectFile;
import org.gradle.internal.Cast;
import org.gradle.internal.serialization.Cached;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.plugins.ide.api.PropertyListGeneratorTask;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateXcodeProjectFileTask
extends PropertyListGeneratorTask<XcodeProjectFile> {
    private static final String PRODUCTS_GROUP_NAME = "Products";
    private static final String UNBUILDABLE_BUILD_CONFIGURATION_NAME = "unbuildable";
    private final GidGenerator gidGenerator;
    private transient DefaultXcodeProject xcodeProject;
    private final Map<String, PBXFileReference> pathToFileReference = new HashMap<String, PBXFileReference>();
    private final Cached<ProjectSpec> spec = Cached.of(this::calculateSpec);

    @Inject
    public GenerateXcodeProjectFileTask(GidGenerator gidGenerator) {
        this.gidGenerator = gidGenerator;
    }

    private ProjectSpec calculateSpec() {
        ArrayList<TargetSpec> targets = new ArrayList<TargetSpec>();
        for (XcodeTarget target : this.xcodeProject.getTargets()) {
            ArrayList<BinarySpec> binaries = new ArrayList<BinarySpec>();
            for (XcodeBinary binary : target.getBinaries()) {
                binaries.add(new BinarySpec(binary.getBuildConfigurationName(), binary.getArchitectureName(), binary.getOutputFile()));
            }
            targets.add(new TargetSpec(target.getName(), target.getId(), target.isBuildable(), target.isUnitTest(), (FileCollection)target.getSources(), (FileCollection)target.getCompileModules(), (FileCollection)target.getHeaderSearchPaths(), target.getTaskName(), target.getOutputFileType(), target.getProductName(), target.getProductType(), target.getDebugOutputFile(), target.getGradleCommand(), (Provider<SwiftVersion>)target.getSwiftSourceCompatibility(), (List<BinarySpec>)binaries));
        }
        return new ProjectSpec(this.getProject().getPath(), (FileCollection)this.xcodeProject.getGroups().getSources(), (FileCollection)this.xcodeProject.getGroups().getHeaders(), (FileCollection)this.xcodeProject.getGroups().getTests(), (FileCollection)this.xcodeProject.getGroups().getRoot(), targets);
    }

    @Override
    protected void configure(XcodeProjectFile projectFile) {
        ProjectSpec spec = (ProjectSpec)this.spec.get();
        PBXProject project = new PBXProject(spec.projectPath);
        this.addToGroup(project.getMainGroup(), spec.sources, "Sources");
        this.addToGroup(project.getMainGroup(), spec.headers, "Headers");
        this.addToGroup(project.getMainGroup(), spec.tests, "Tests");
        this.addToGroup(project.getMainGroup(), (Iterable<File>)spec.root);
        for (TargetSpec xcodeTarget : spec.targets) {
            if (xcodeTarget.buildable) {
                project.getTargets().add(this.toGradlePbxTarget(spec, xcodeTarget));
            } else {
                this.getLogger().warn("'" + xcodeTarget.name + "' component in project '" + spec.projectPath + "' is not buildable.");
            }
            project.getTargets().add(this.toIndexPbxTarget(xcodeTarget));
            if (xcodeTarget.unitTest || !xcodeTarget.debugOutputFile.isPresent()) continue;
            File debugOutputFile = ((FileSystemLocation)xcodeTarget.debugOutputFile.get()).getAsFile();
            PBXFileReference fileReference = new PBXFileReference(debugOutputFile.getName(), debugOutputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
            fileReference.setExplicitFileType((Optional<String>)Optional.of((Object)xcodeTarget.outputFileType));
            project.getMainGroup().getOrCreateChildGroupByName(PRODUCTS_GROUP_NAME).getChildren().add(fileReference);
        }
        project.getTargets().stream().flatMap(it -> it.getBuildConfigurationList().getBuildConfigurationsByName().asMap().keySet().stream()).forEach(arg_0 -> project.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked(arg_0));
        XcodeprojSerializer serializer = new XcodeprojSerializer(this.gidGenerator, project);
        NSDictionary rootObject = serializer.toPlist();
        projectFile.transformAction(dict -> {
            dict.clear();
            dict.putAll((Map)rootObject);
        });
    }

    private void addToGroup(PBXGroup mainGroup, FileCollection sources, String groupName) {
        if (!sources.isEmpty()) {
            this.addToGroup(mainGroup.getOrCreateChildGroupByName(groupName), (Iterable<File>)sources);
        }
    }

    private void addToGroup(PBXGroup group, Iterable<File> sources) {
        for (File source : sources) {
            PBXFileReference fileReference = this.toFileReference(source);
            this.pathToFileReference.put(source.getAbsolutePath(), fileReference);
            group.getChildren().add(fileReference);
        }
    }

    private List<BinarySpec> getAllBinaries(ProjectSpec xcodeProject) {
        return xcodeProject.targets.stream().map(it -> it.binaries).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected XcodeProjectFile create() {
        return new XcodeProjectFile((PropertyListTransformer)Cast.uncheckedNonnullCast((Object)this.getPropertyListTransformer()));
    }

    private PBXFileReference toFileReference(File file) {
        return new PBXFileReference(file.getName(), file.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
    }

    private PBXTarget toGradlePbxTarget(ProjectSpec xcodeProject, TargetSpec xcodeTarget) {
        if (xcodeTarget.unitTest) {
            return this.toXCTestPbxTarget(xcodeProject, xcodeTarget);
        }
        return this.toToolAndLibraryPbxTarget(xcodeTarget);
    }

    private PBXTarget toToolAndLibraryPbxTarget(TargetSpec xcodeTarget) {
        PBXLegacyTarget target = new PBXLegacyTarget(xcodeTarget.name, xcodeTarget.productType);
        target.setProductName(xcodeTarget.productName);
        target.setBuildToolPath(xcodeTarget.gradleCommand);
        target.setBuildArgumentsString(this.buildGradleArgs(xcodeTarget));
        target.setGlobalID(xcodeTarget.id);
        File outputFile = ((FileSystemLocation)xcodeTarget.debugOutputFile.get()).getAsFile();
        target.setProductReference(new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
        xcodeTarget.binaries.forEach(xcodeBinary -> {
            NSDictionary settings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)xcodeBinary.buildConfigurationName)).getBuildSettings();
            File binaryOutputFile = ((FileSystemLocation)xcodeBinary.outputFile.get()).getAsFile();
            settings.put("CONFIGURATION_BUILD_DIR", (NSObject)new NSString(binaryOutputFile.getParentFile().getAbsolutePath()));
            settings.put("PRODUCT_NAME", (Object)target.getProductName());
            settings.put("SWIFT_VERSION", (Object)GenerateXcodeProjectFileTask.toXcodeSwiftVersion(xcodeTarget.swiftSourceCompatibility));
            settings.put("ARCHS", (Object)GenerateXcodeProjectFileTask.toXcodeArchitecture(xcodeBinary.architectureName));
            settings.put("VALID_ARCHS", (Object)xcodeTarget.binaries.stream().map(it -> it.architectureName).map(GenerateXcodeProjectFileTask::toXcodeArchitecture).distinct().collect(Collectors.joining(" ")));
        });
        return target;
    }

    private String buildGradleArgs(TargetSpec xcodeTarget) {
        return Joiner.on((char)' ').join(XcodePropertyAdapter.getAdapterCommandLine()) + " " + xcodeTarget.taskName;
    }

    private PBXTarget toXCTestPbxTarget(ProjectSpec xcodeProject, TargetSpec xcodeTarget) {
        PBXShellScriptBuildPhase hackBuildPhase = new PBXShellScriptBuildPhase();
        hackBuildPhase.setShellPath("/bin/sh");
        hackBuildPhase.setShellScript("# Script to generate specific Swift files Xcode expects when running tests.\nset -eu\nARCH_ARRAY=($ARCHS)\nSUFFIXES=(swiftdoc swiftmodule h)\nfor ARCH in \"${ARCH_ARRAY[@]}\"\ndo\n  for SUFFIX in \"${SUFFIXES[@]}\"\n  do\n    touch \"$OBJECT_FILE_DIR_normal/$ARCH/$PRODUCT_NAME.$SUFFIX\"\n  done\ndone");
        PBXShellScriptBuildPhase gradleBuildPhase = new PBXShellScriptBuildPhase();
        gradleBuildPhase.setShellPath("/bin/sh");
        gradleBuildPhase.setShellScript("exec \"" + xcodeTarget.gradleCommand + "\" " + this.buildGradleArgs(xcodeTarget) + " < /dev/null");
        PBXNativeTarget target = new PBXNativeTarget(xcodeTarget.name, xcodeTarget.productType);
        target.setProductName(xcodeTarget.productName);
        target.setGlobalID(xcodeTarget.id);
        target.getBuildPhases().add(hackBuildPhase);
        target.getBuildPhases().add(this.newSourceBuildPhase(xcodeTarget.sources));
        target.getBuildPhases().add(gradleBuildPhase);
        File outputFile = ((FileSystemLocation)xcodeTarget.debugOutputFile.get()).getAsFile();
        target.setProductReference(new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
        this.getAllBinaries(xcodeProject).stream().filter(it -> !Objects.equals(it.buildConfigurationName, "__GradleTestRunner_Debug")).forEach(this.configureBuildSettings(xcodeTarget, target));
        NSDictionary testRunnerSettings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"__GradleTestRunner_Debug")).getBuildSettings();
        if (!xcodeTarget.compileModules.isEmpty()) {
            testRunnerSettings.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(GenerateXcodeProjectFileTask.parentDirs((Iterable<File>)xcodeTarget.compileModules)));
        }
        testRunnerSettings.put("SWIFT_VERSION", (Object)GenerateXcodeProjectFileTask.toXcodeSwiftVersion(xcodeTarget.swiftSourceCompatibility));
        testRunnerSettings.put("PRODUCT_NAME", (Object)target.getProductName());
        testRunnerSettings.put("OTHER_LDFLAGS", (Object)"-help");
        testRunnerSettings.put("OTHER_CFLAGS", (Object)"-help");
        testRunnerSettings.put("OTHER_SWIFT_FLAGS", (Object)"-help");
        testRunnerSettings.put("SWIFT_INSTALL_OBJC_HEADER", (Object)"NO");
        testRunnerSettings.put("SWIFT_OBJC_INTERFACE_HEADER_NAME", (Object)"$(PRODUCT_NAME).h");
        return target;
    }

    private PBXTarget toIndexPbxTarget(TargetSpec xcodeTarget) {
        PBXNativeTarget target = new PBXNativeTarget("[INDEXING ONLY] " + xcodeTarget.name, PBXTarget.ProductType.INDEXER);
        target.setProductName(xcodeTarget.productName);
        target.getBuildPhases().add(this.newSourceBuildPhase(xcodeTarget.sources));
        xcodeTarget.binaries.forEach(this.configureBuildSettings(xcodeTarget, target));
        if (xcodeTarget.binaries.isEmpty()) {
            NSDictionary settings = this.newBuildSettings(xcodeTarget);
            ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)UNBUILDABLE_BUILD_CONFIGURATION_NAME)).setBuildSettings(settings);
        }
        return target;
    }

    private Consumer<BinarySpec> configureBuildSettings(TargetSpec xcodeTarget, PBXNativeTarget target) {
        return xcodeBinary -> {
            NSDictionary settings = this.newBuildSettings(xcodeTarget);
            settings.put("ARCHS", (Object)GenerateXcodeProjectFileTask.toXcodeArchitecture(xcodeBinary.architectureName));
            settings.put("VALID_ARCHS", (Object)xcodeTarget.binaries.stream().map(it -> GenerateXcodeProjectFileTask.toXcodeArchitecture(it.architectureName)).distinct().collect(Collectors.joining(" ")));
            ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)xcodeBinary.buildConfigurationName)).setBuildSettings(settings);
        };
    }

    private PBXSourcesBuildPhase newSourceBuildPhase(FileCollection sourceFiles) {
        PBXSourcesBuildPhase result = new PBXSourcesBuildPhase();
        for (File file : sourceFiles) {
            PBXFileReference fileReference = this.pathToFileReference.get(file.getAbsolutePath());
            result.getFiles().add(new PBXBuildFile(fileReference));
        }
        return result;
    }

    private NSDictionary newBuildSettings(TargetSpec xcodeTarget) {
        NSDictionary result = new NSDictionary();
        result.put("SWIFT_VERSION", (Object)GenerateXcodeProjectFileTask.toXcodeSwiftVersion(xcodeTarget.swiftSourceCompatibility));
        result.put("PRODUCT_NAME", (Object)xcodeTarget.productName);
        if (!xcodeTarget.headerSearchPaths.isEmpty()) {
            result.put("HEADER_SEARCH_PATHS", (Object)XcodeUtils.toSpaceSeparatedList((Iterable<File>)xcodeTarget.headerSearchPaths));
        }
        if (!xcodeTarget.compileModules.isEmpty()) {
            result.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(GenerateXcodeProjectFileTask.parentDirs((Iterable<File>)xcodeTarget.compileModules)));
        }
        return result;
    }

    private static String toXcodeArchitecture(String architectureName) {
        if (architectureName.equals("x86")) {
            return "i386";
        }
        if (architectureName.equals("x86-64")) {
            return "x86_64";
        }
        if (architectureName.equals("aarch64")) {
            return "arm64e";
        }
        return architectureName;
    }

    private static String toXcodeSwiftVersion(Provider<SwiftVersion> swiftVersion) {
        if (swiftVersion.isPresent()) {
            return String.format("%d.0", ((SwiftVersion)swiftVersion.get()).getVersion());
        }
        return null;
    }

    private static Iterable<File> parentDirs(Iterable<File> files) {
        ArrayList<File> parents = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                parents.add(file);
                continue;
            }
            parents.add(file.getParentFile());
        }
        return parents;
    }

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }

    private static class BinarySpec {
        final String buildConfigurationName;
        final String architectureName;
        final Provider<? extends FileSystemLocation> outputFile;

        public BinarySpec(String buildConfigurationName, String architectureName, Provider<? extends FileSystemLocation> outputFile) {
            this.buildConfigurationName = buildConfigurationName;
            this.architectureName = architectureName;
            this.outputFile = outputFile;
        }
    }

    private static class TargetSpec {
        final String name;
        final String id;
        final boolean buildable;
        final boolean unitTest;
        final FileCollection sources;
        final FileCollection compileModules;
        final FileCollection headerSearchPaths;
        final String taskName;
        final String outputFileType;
        final String productName;
        final PBXTarget.ProductType productType;
        final Provider<? extends FileSystemLocation> debugOutputFile;
        final String gradleCommand;
        final Provider<SwiftVersion> swiftSourceCompatibility;
        final List<BinarySpec> binaries;

        public TargetSpec(String name, String id, boolean buildable, boolean unitTest, FileCollection sources, FileCollection compileModules, FileCollection headerSearchPaths, String taskName, String outputFileType, String productName, PBXTarget.ProductType productType, Provider<? extends FileSystemLocation> debugOutputFile, String gradleCommand, Provider<SwiftVersion> swiftSourceCompatibility, List<BinarySpec> binaries) {
            this.name = name;
            this.id = id;
            this.buildable = buildable;
            this.unitTest = unitTest;
            this.sources = sources;
            this.compileModules = compileModules;
            this.headerSearchPaths = headerSearchPaths;
            this.taskName = taskName;
            this.outputFileType = outputFileType;
            this.productName = productName;
            this.productType = productType;
            this.debugOutputFile = debugOutputFile;
            this.gradleCommand = gradleCommand;
            this.swiftSourceCompatibility = swiftSourceCompatibility;
            this.binaries = binaries;
        }
    }

    private static class ProjectSpec {
        final String projectPath;
        final FileCollection sources;
        final FileCollection headers;
        final FileCollection tests;
        final FileCollection root;
        final List<TargetSpec> targets;

        public ProjectSpec(String projectPath, FileCollection sources, FileCollection headers, FileCollection tests, FileCollection root, List<TargetSpec> targets) {
            this.projectPath = projectPath;
            this.sources = sources;
            this.headers = headers;
            this.tests = tests;
            this.root = root;
            this.targets = targets;
        }
    }
}

