/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal.antlr2;

import antlr.Tool;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.plugins.antlr.internal.antlr2.GrammarFileMetadata;
import org.gradle.api.plugins.antlr.internal.antlr2.XRef;
import org.gradle.internal.UncheckedException;
import org.jspecify.annotations.Nullable;

public class MetadataExtracter {
    public XRef extractMetadata(Set<File> sources) {
        Tool tool = new Tool();
        Hierarchy hierarchy = new Hierarchy(tool);
        for (File grammarFileFile : sources) {
            String grammarFilePath = grammarFileFile.getPath();
            try {
                hierarchy.readGrammarFile(grammarFilePath);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Received FileNotFoundException on already read file", e);
            }
        }
        XRef xref = new XRef(hierarchy);
        for (File grammarFileFile : sources) {
            String grammarPackageName = this.getPackageName(grammarFileFile);
            String grammarFilePath = grammarFileFile.getPath();
            GrammarFile antlrGrammarFile = hierarchy.getFile(grammarFilePath);
            GrammarFileMetadata grammarFileMetadata = new GrammarFileMetadata(grammarFileFile, antlrGrammarFile, grammarPackageName);
            xref.addGrammarFile(grammarFileMetadata);
        }
        return xref;
    }

    private @Nullable String getPackageName(File grammarFileFile) {
        try {
            return this.getPackageName(Files.newBufferedReader(grammarFileFile.toPath(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read antlr grammar file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPackageName(Reader reader) throws IOException {
        String grammarPackageName = null;
        BufferedReader in = new BufferedReader(reader);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                Pattern p;
                Matcher m;
                if ((line = line.trim()).startsWith("package") && line.endsWith(";")) {
                    grammarPackageName = line.substring(8, line.length() - 1);
                    continue;
                }
                if (!line.startsWith("header") || !(m = (p = Pattern.compile("header \\{\\s*package\\s+(.+);\\s+\\}")).matcher(line)).matches()) continue;
                grammarPackageName = m.group(1);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return grammarPackageName;
    }
}

