/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.List;
import org.gradle.api.JavaVersion;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.internal.artifacts.dsl.dependencies.AbstractJVMVersionTooNewFailureDescriber;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.exception.AbstractResolutionFailureException;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByAttributesException;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;

public abstract class TargetJVMVersionOnLibraryTooNewFailureDescriber
extends AbstractJVMVersionTooNewFailureDescriber {
    private static final String JVM_VERSION_TOO_HIGH_TEMPLATE = "Dependency resolution is looking for a library compatible with JVM runtime version %s, but '%s' is only compatible with JVM runtime version %s or newer.";

    @Override
    protected JavaVersion getJVMVersion(NoCompatibleVariantsFailure failure) {
        ImmutableAttributesEntry jvmVersionEntry = failure.getRequestedAttributes().findEntry(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE);
        return JavaVersion.toVersion((Object)jvmVersionEntry.getIsolatedValue());
    }

    @Override
    public boolean canDescribeFailure(NoCompatibleVariantsFailure failure) {
        boolean isPluginRequest = failure.getRequestedAttributes().contains(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE);
        return !isPluginRequest && this.isDueToJVMVersionTooNew(failure);
    }

    @Override
    public AbstractResolutionFailureException describeFailure(NoCompatibleVariantsFailure failure) {
        JavaVersion minJVMVersionSupported = this.findMinJVMSupported((List<ResolutionCandidateAssessor.AssessedCandidate>)failure.getCandidates()).orElseThrow(IllegalStateException::new);
        JavaVersion requestedJVMVersion = this.getJVMVersion(failure);
        String message = this.buildNeedsNewerJDKFailureMsg(failure.describeRequestTarget(), minJVMVersionSupported, failure);
        List<String> resolutions = this.buildResolutions(this.suggestChangeLibraryVersion(failure.describeRequestTarget(), requestedJVMVersion));
        return new VariantSelectionByAttributesException(message, failure, resolutions);
    }

    private String buildNeedsNewerJDKFailureMsg(String requestedName, JavaVersion minRequiredJVMVersion, NoCompatibleVariantsFailure failure) {
        return String.format(JVM_VERSION_TOO_HIGH_TEMPLATE, this.getJVMVersion(failure).getMajorVersion(), requestedName, minRequiredJVMVersion.getMajorVersion());
    }

    private String suggestChangeLibraryVersion(String requestedName, JavaVersion minRequiredJVMVersion) {
        return "Change the dependency on '" + requestedName + "' to an earlier version that supports JVM runtime version " + minRequiredJVMVersion.getMajorVersion() + ".";
    }
}

