/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.initialization.internal.SharedModelDefaultsInternal;
import org.gradle.api.internal.initialization.ActionBasedDefault;
import org.gradle.internal.Cast;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.plugin.software.internal.ProjectFeatureDeclarations;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.gradle.util.internal.ClosureBackedAction;

public class DefaultSharedModelDefaults
implements SharedModelDefaultsInternal,
MethodMixIn {
    private final ProjectFeatureDeclarations projectFeatureDeclarations;
    private final DynamicMethods dynamicMethods = new DynamicMethods();
    private final ThreadLocal<ProjectLayout> projectLayout = new ThreadLocal();

    @Inject
    public DefaultSharedModelDefaults(ProjectFeatureDeclarations projectFeatureDeclarations) {
        this.projectFeatureDeclarations = projectFeatureDeclarations;
    }

    public void setProjectLayout(ProjectLayout projectLayout) {
        this.projectLayout.set(projectLayout);
    }

    public void clearProjectLayout() {
        this.projectLayout.remove();
    }

    public ProjectLayout getLayout() {
        ProjectLayout instance = this.projectLayout.get();
        if (instance == null) {
            throw new GradleException("ProjectLayout should be referenced only inside of project type default configuration blocks");
        }
        return instance;
    }

    public <T> void add(String name, Class<T> publicType, Action<? super T> configureAction) {
        ProjectFeatureImplementation projectFeature;
        if (this.projectFeatureDeclarations.getProjectFeatureImplementations().containsKey(name)) {
            projectFeature = (ProjectFeatureImplementation)this.projectFeatureDeclarations.getProjectFeatureImplementations().get(name);
            if (!projectFeature.getDefinitionPublicType().isAssignableFrom(publicType)) {
                throw new IllegalArgumentException(String.format("Cannot add convention for project type '%s' with public type '%s'. Expected public type to be assignable from '%s'.", name, publicType, projectFeature.getDefinitionPublicType()));
            }
        } else {
            throw new IllegalArgumentException(String.format("Cannot add convention for unknown project type '%s'.", name));
        }
        projectFeature.addModelDefault(new ActionBasedDefault<T>(configureAction));
    }

    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    class DynamicMethods
    implements MethodAccess {
        DynamicMethods() {
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return arguments.length == 1 && (arguments[0] instanceof Action || arguments[0] instanceof Closure) && DefaultSharedModelDefaults.this.projectFeatureDeclarations.getProjectFeatureImplementations().containsKey(name);
        }

        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            if (this.hasMethod(name, arguments)) {
                ProjectFeatureImplementation projectFeature = (ProjectFeatureImplementation)DefaultSharedModelDefaults.this.projectFeatureDeclarations.getProjectFeatureImplementations().get(name);
                DefaultSharedModelDefaults.this.add(name, projectFeature.getDefinitionPublicType(), (Action)Cast.uncheckedNonnullCast(this.toAction(arguments[0])));
                return DynamicInvokeResult.found();
            }
            return DynamicInvokeResult.notFound();
        }

        private Action<?> toAction(Object argument) {
            if (argument instanceof Action) {
                return (Action)Cast.uncheckedNonnullCast((Object)argument);
            }
            if (argument instanceof Closure) {
                return ClosureBackedAction.of((Closure)((Closure)argument));
            }
            throw new IllegalArgumentException("Expected an Action or Closure, but received: " + argument);
        }
    }
}

